/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IcebergOrcColumn {
    public static final int ROOT_COLUMN_ID = 0;
    private int orcColumnId;
    private int orcFieldTypeIndex;
    private Optional<Integer> icebergColumnId;
    private String columnName;
    private BaseHiveColumnHandle.ColumnType columnType;
    private OrcType.OrcTypeKind orcType;
    private Map<String, String> attributes;

    public IcebergOrcColumn(int orcColumnId, int orcFieldTypeIndex, Optional<Integer> icebergColumnId, String columnName, BaseHiveColumnHandle.ColumnType columnType, OrcType.OrcTypeKind orcType, Map<String, String> attributes) {
        Preconditions.checkArgument((orcColumnId >= 0 ? 1 : 0) != 0, (Object)"orcColumnId is negative");
        Preconditions.checkArgument((orcFieldTypeIndex >= 0 ? 1 : 0) != 0, (Object)"orcFieldTypeIndex is negative");
        this.orcColumnId = orcColumnId;
        this.orcFieldTypeIndex = orcFieldTypeIndex;
        this.icebergColumnId = Objects.requireNonNull(icebergColumnId, "icebergColumnId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.orcType = Objects.requireNonNull(orcType, "orcType is null");
        this.attributes = ImmutableMap.copyOf(Objects.requireNonNull(attributes, "attributes is null"));
    }

    public int getOrcColumnId() {
        return this.orcColumnId;
    }

    public int getOrcFieldTypeIndex() {
        return this.orcFieldTypeIndex;
    }

    public Optional<Integer> getIcebergColumnId() {
        return this.icebergColumnId;
    }

    public IcebergOrcColumn setIcebergColumnId(Optional<Integer> icebergColumnId) {
        this.icebergColumnId = Objects.requireNonNull(icebergColumnId, "icebergColumnId is null");
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public IcebergOrcColumn setColumnName(String columnName) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        return this;
    }

    public BaseHiveColumnHandle.ColumnType getColumnType() {
        return this.columnType;
    }

    public IcebergOrcColumn setColumnType(BaseHiveColumnHandle.ColumnType columnType) {
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        return this;
    }

    public OrcType.OrcTypeKind getOrcType() {
        return this.orcType;
    }

    public IcebergOrcColumn setOrcType(OrcType.OrcTypeKind orcType) {
        this.orcType = Objects.requireNonNull(orcType, "orcType is null");
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public static IcebergOrcColumn copy(IcebergOrcColumn other) {
        Objects.requireNonNull(other, "copy from other IcebergOrcColumn is null");
        return new IcebergOrcColumn(other.getOrcColumnId(), other.getOrcFieldTypeIndex(), other.getIcebergColumnId(), other.getColumnName(), other.getColumnType(), other.getOrcType(), other.getAttributes());
    }

    public String toString() {
        return "IcebergOrcColumn{orcColumnId=" + this.orcColumnId + ", orcFieldTypeIndex=" + this.orcFieldTypeIndex + ", icebergColumnId=" + this.icebergColumnId + ", columnName='" + this.columnName + '\'' + ", columnType=" + this.columnType + ", orcType=" + this.orcType + ", attributes=" + this.attributes + '}';
    }
}

