/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.Utils;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergMetadataColumn;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.delete.RowPredicate;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class IcebergPageSource
implements ConnectorPageSource {
    private final Block[] prefilledBlocks;
    private final int[] delegateIndexes;
    private final ConnectorPageSource delegate;
    private final Supplier<Optional<RowPredicate>> deletePredicate;

    public IcebergPageSource(List<IcebergColumnHandle> columns, Map<Integer, Object> metadataValues, Map<Integer, HivePartitionKey> partitionKeys, ConnectorPageSource delegate, Supplier<Optional<RowPredicate>> deletePredicate) {
        int size = Objects.requireNonNull(columns, "columns is null").size();
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.deletePredicate = Objects.requireNonNull(deletePredicate, "deletePredicate is null");
        this.prefilledBlocks = new Block[size];
        this.delegateIndexes = new int[size];
        int outputIndex = 0;
        int delegateIndex = 0;
        for (IcebergColumnHandle column : columns) {
            if (partitionKeys.containsKey(column.getId())) {
                HivePartitionKey icebergPartition = partitionKeys.get(column.getId());
                Type type = column.getType();
                Object prefilledValue = IcebergUtil.deserializePartitionValue(type, icebergPartition.getValue().orElse(null), column.getName());
                this.prefilledBlocks[outputIndex] = this.nativeValueToBlock(type, prefilledValue);
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getColumnType() == BaseHiveColumnHandle.ColumnType.PARTITION_KEY) {
                Type type = column.getType();
                this.prefilledBlocks[outputIndex] = this.nativeValueToBlock(type, null);
                this.delegateIndexes[outputIndex] = -1;
            } else if (IcebergMetadataColumn.isMetadataColumnId(column.getId())) {
                this.prefilledBlocks[outputIndex] = this.nativeValueToBlock(column.getType(), metadataValues.get(column.getColumnIdentity().getId()));
                this.delegateIndexes[outputIndex] = -1;
            } else {
                this.delegateIndexes[outputIndex] = delegateIndex++;
            }
            ++outputIndex;
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            Optional<RowPredicate> deleteFilterPredicate = this.deletePredicate.get();
            if (deleteFilterPredicate.isPresent()) {
                dataPage = deleteFilterPredicate.get().filterPage(dataPage);
            }
            int batchSize = dataPage.getPositionCount();
            Block[] blocks = new Block[this.prefilledBlocks.length];
            for (int i = 0; i < this.prefilledBlocks.length; ++i) {
                blocks[i] = this.prefilledBlocks[i] != null ? new RunLengthEncodedBlock(this.prefilledBlocks[i], batchSize) : dataPage.getBlock(this.delegateIndexes[i]);
            }
            return new Page(batchSize, blocks);
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            Throwables.throwIfInstanceOf((Throwable)e, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private Block nativeValueToBlock(Type type, Object prefilledValue) {
        if (prefilledValue != null && (type instanceof TimestampType && ((TimestampType)type).getPrecision() == TimeUnit.MILLISECONDS || type instanceof TimeType)) {
            return Utils.nativeValueToBlock((Type)type, (Object)TimeUnit.MICROSECONDS.toMillis((Long)prefilledValue));
        }
        return Utils.nativeValueToBlock((Type)type, (Object)prefilledValue);
    }
}

