/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveOrcAggregatedMemoryContext;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcBatchPageSource;
import com.facebook.presto.hive.orc.ProjectionBasedDwrfKeyProvider;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.iceberg.FileContent;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergMetadataColumn;
import com.facebook.presto.iceberg.IcebergOrcColumn;
import com.facebook.presto.iceberg.IcebergPageSource;
import com.facebook.presto.iceberg.IcebergSplit;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.changelog.ChangelogPageSource;
import com.facebook.presto.iceberg.delete.DeleteFile;
import com.facebook.presto.iceberg.delete.DeleteFilter;
import com.facebook.presto.iceberg.delete.EqualityDeleteFilter;
import com.facebook.presto.iceberg.delete.PositionDeleteFilter;
import com.facebook.presto.iceberg.delete.RowPredicate;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.PredicateUtils;
import com.facebook.presto.parquet.reader.ColumnIndexFilterUtils;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final TypeManager typeManager;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSourceFactory stripeMetadataSourceFactory;
    private final DwrfEncryptionProvider dwrfEncryptionProvider;
    private final HiveClientConfig hiveClientConfig;
    private final ParquetMetadataSource parquetMetadataSource;

    @Inject
    public IcebergPageSourceProvider(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats fileFormatDataSourceStats, TypeManager typeManager, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, HiveDwrfEncryptionProvider dwrfEncryptionProvider, HiveClientConfig hiveClientConfig, ParquetMetadataSource parquetMetadataSource) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        this.stripeMetadataSourceFactory = Objects.requireNonNull(stripeMetadataSourceFactory, "stripeMetadataSourceFactory is null");
        this.dwrfEncryptionProvider = Objects.requireNonNull(dwrfEncryptionProvider, "DwrfEncryptionProvider is null").toDwrfEncryptionProvider();
        this.hiveClientConfig = Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.parquetMetadataSource = Objects.requireNonNull(parquetMetadataSource, "parquetMetadataSource is null");
    }

    private static ConnectorPageSourceWithRowPositions createParquetPageSource(HdfsEnvironment hdfsEnvironment, ConnectorSession session, Configuration configuration, Path path, long start, long length, List<IcebergColumnHandle> regularColumns, TupleDomain<IcebergColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats, ParquetMetadataSource parquetMetadataSource) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        String user = session.getUser();
        boolean readMaskedValue = HiveCommonSessionProperties.getReadNullMaskedParquetEncryptedValue((ConnectorSession)session);
        HdfsParquetDataSource dataSource = null;
        try {
            HdfsParquetDataSource parquetDataSource;
            ExtendedFileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            long fileSize = fileStatus.getLen();
            long modificationTime = fileStatus.getModificationTime();
            HiveFileContext hiveFileContext = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), OptionalLong.of(fileSize), OptionalLong.of(start), OptionalLong.of(length), modificationTime, false);
            FSDataInputStream inputStream = fileSystem.openFile(path, hiveFileContext);
            dataSource = parquetDataSource = HdfsParquetDataSource.buildHdfsParquetDataSource((FSDataInputStream)inputStream, (Path)path, (FileFormatDataSourceStats)fileFormatDataSourceStats);
            Optional fileDecryptor = ParquetPageSourceFactory.createDecryptor((Configuration)configuration, (Path)path);
            ParquetMetadata parquetMetadata = (ParquetMetadata)hdfsEnvironment.doAs(user, () -> IcebergPageSourceProvider.lambda$createParquetPageSource$0(parquetMetadataSource, (ParquetDataSource)parquetDataSource, fileSize, hiveFileContext, fileDecryptor, readMaskedValue));
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Map parquetIdToField = (Map)fileSchema.getFields().stream().filter(field -> field.getId() != null).collect(ImmutableMap.toImmutableMap(field -> field.getId().intValue(), Function.identity()));
            Optional<MessageType> messageType = regularColumns.stream().map(column -> IcebergPageSourceProvider.getColumnType(parquetIdToField, fileSchema, column)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchema.getName(), new org.apache.parquet.schema.Type[]{type})).reduce(MessageType::union);
            MessageType requestedSchema = messageType.orElse(new MessageType(fileSchema.getName(), (List)ImmutableList.of()));
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath);
            HdfsParquetDataSource finalDataSource = dataSource;
            long nextStart = 0L;
            Optional<Long> startRowPosition = Optional.empty();
            Optional<Long> endRowPosition = Optional.empty();
            ImmutableList.Builder blockStarts = ImmutableList.builder();
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            ArrayList<Object> blockIndexStores = new ArrayList<Object>();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                Optional firstIndex = MetadataReader.findFirstNonHiddenColumnId((BlockMetaData)block);
                if (!firstIndex.isPresent()) continue;
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get((Integer)firstIndex.get())).getFirstDataPageOffset();
                Optional columnIndexStore = ColumnIndexFilterUtils.getColumnIndexStore((Predicate)parquetPredicate, (ParquetDataSource)finalDataSource, (BlockMetaData)block, (Map)descriptorsByPath, (boolean)false);
                if (firstDataPage >= start && firstDataPage < start + length && PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain, (Optional)columnIndexStore, (boolean)false, Optional.of(session.getWarningCollector()))) {
                    blocks.add(block);
                    blockIndexStores.add(columnIndexStore.orElse(null));
                    blockStarts.add((Object)nextStart);
                    if (!startRowPosition.isPresent()) {
                        startRowPosition = Optional.of(nextStart);
                    }
                    endRowPosition = Optional.of(nextStart + block.getRowCount());
                }
                nextStart += block.getRowCount();
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, blocks, Optional.of(blockStarts.build()), (ParquetDataSource)dataSource, systemMemoryContext, HiveCommonSessionProperties.getParquetMaxReadBlockSize((ConnectorSession)session), HiveCommonSessionProperties.isParquetBatchReadsEnabled((ConnectorSession)session), HiveCommonSessionProperties.isParquetBatchReaderVerificationEnabled((ConnectorSession)session), parquetPredicate, blockIndexStores, false, fileDecryptor);
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            ImmutableList.Builder prestoTypes = ImmutableList.builder();
            ImmutableList.Builder internalFields = ImmutableList.builder();
            ArrayList<Boolean> isRowPositionList = new ArrayList<Boolean>();
            for (int columnIndex = 0; columnIndex < regularColumns.size(); ++columnIndex) {
                IcebergColumnHandle column2 = regularColumns.get(columnIndex);
                namesBuilder.add((Object)column2.getName());
                com.facebook.presto.common.type.Type prestoType = column2.getType();
                prestoTypes.add((Object)prestoType);
                if (column2.getColumnType() == BaseHiveColumnHandle.ColumnType.SYNTHESIZED) {
                    Subfield pushedDownSubfield = IcebergColumnHandle.getPushedDownSubfield(column2);
                    List nestedColumnPath = ParquetTypeUtils.nestedColumnPath((Subfield)pushedDownSubfield);
                    Optional columnIO = ColumnIOConverter.findNestedColumnIO((ColumnIO)ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumnIO, (String)pushedDownSubfield.getRootName()), (List)nestedColumnPath);
                    if (columnIO.isPresent()) {
                        internalFields.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)prestoType, (ColumnIO)((ColumnIO)columnIO.get())));
                    } else {
                        internalFields.add(Optional.empty());
                    }
                } else {
                    Optional<org.apache.parquet.schema.Type> parquetField = IcebergPageSourceProvider.getColumnType(parquetIdToField, fileSchema, column2);
                    if (!parquetField.isPresent()) {
                        internalFields.add(Optional.empty());
                    } else {
                        internalFields.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)column2.getType(), (ColumnIO)messageColumnIO.getChild(parquetField.get().getName())));
                    }
                }
                isRowPositionList.add(column2.isRowPositionColumn());
            }
            return new ConnectorPageSourceWithRowPositions((ConnectorPageSource)new ParquetPageSource(parquetReader, (List)prestoTypes.build(), (List)internalFields.build(), isRowPositionList, (List)namesBuilder.build(), new RuntimeStats()), startRowPosition, endRowPosition);
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException fileStatus) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof ParquetCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, message, (Throwable)e);
            }
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    public static Optional<org.apache.parquet.schema.Type> getColumnType(Map<Integer, org.apache.parquet.schema.Type> parquetIdToField, MessageType messageType, IcebergColumnHandle column) {
        if (IcebergColumnHandle.isPushedDownSubfield(column)) {
            Subfield pushedDownSubfield = IcebergColumnHandle.getPushedDownSubfield(column);
            return ParquetTypeUtils.getSubfieldType((GroupType)messageType, (String)pushedDownSubfield.getRootName(), (List)ParquetTypeUtils.nestedColumnPath((Subfield)pushedDownSubfield));
        }
        if (parquetIdToField.isEmpty()) {
            return Optional.ofNullable(ParquetTypeUtils.getParquetTypeByName((String)column.getName(), (GroupType)messageType));
        }
        return Optional.ofNullable(parquetIdToField.get(column.getId()));
    }

    private static BaseHiveColumnHandle.ColumnType getHiveColumnHandleColumnType(BaseHiveColumnHandle.ColumnType columnType) {
        switch (columnType) {
            case REGULAR: {
                return BaseHiveColumnHandle.ColumnType.REGULAR;
            }
            case SYNTHESIZED: {
                return BaseHiveColumnHandle.ColumnType.SYNTHESIZED;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unknown ColumnType: " + columnType);
    }

    private static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<IcebergColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            RichColumnDescriptor descriptor;
            String baseType = columnHandle.getType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row") || (descriptor = (RichColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()))) == null)) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    private static ConnectorPageSourceWithRowPositions createBatchOrcPageSource(HdfsEnvironment hdfsEnvironment, String user, Configuration configuration, Path path, long start, long length, boolean isCacheable, List<IcebergColumnHandle> regularColumns, TypeManager typeManager, TupleDomain<IcebergColumnHandle> effectivePredicate, OrcReaderOptions options, OrcEncoding orcEncoding, DataSize maxBufferSize, DataSize streamBufferSize, boolean lazyReadSmallRanges, boolean orcBloomFiltersEnabled, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, FileFormatDataSourceStats stats, Optional<EncryptionInformation> encryptionInformation, DwrfEncryptionProvider dwrfEncryptionProvider) {
        HdfsOrcDataSource orcDataSource = null;
        try {
            ExtendedFileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            long fileSize = fileStatus.getLen();
            long modificationTime = fileStatus.getModificationTime();
            HiveFileContext hiveFileContext = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), OptionalLong.of(fileSize), OptionalLong.of(start), OptionalLong.of(length), modificationTime, false);
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(user, () -> fileSystem.openFile(path, hiveFileContext));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, options.getMaxMergeDistance(), maxBufferSize, streamBufferSize, lazyReadSmallRanges, inputStream, stats);
            ProjectionBasedDwrfKeyProvider dwrfKeyProvider = new ProjectionBasedDwrfKeyProvider(encryptionInformation, (List)ImmutableList.of(), true, path);
            RuntimeStats runtimeStats = new RuntimeStats();
            OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, orcEncoding, orcFileTailSource, stripeMetadataSourceFactory, (OrcAggregatedMemoryContext)new HiveOrcAggregatedMemoryContext(), options, isCacheable, dwrfEncryptionProvider, (DwrfKeyProvider)dwrfKeyProvider, runtimeStats);
            ArrayList<HiveColumnHandle> physicalColumnHandles = new ArrayList<HiveColumnHandle>(regularColumns.size());
            ImmutableMap.Builder includedColumns = ImmutableMap.builder();
            ImmutableList.Builder columnReferences = ImmutableList.builder();
            List<IcebergOrcColumn> fileOrcColumns = IcebergPageSourceProvider.getFileOrcColumns(reader);
            Map fileOrcColumnByIcebergId = (Map)fileOrcColumns.stream().filter(orcColumn -> orcColumn.getAttributes().containsKey("iceberg.id")).collect(ImmutableMap.toImmutableMap(orcColumn -> Integer.parseInt(orcColumn.getAttributes().get("iceberg.id")), orcColumn -> IcebergOrcColumn.copy(orcColumn).setIcebergColumnId(Optional.of(Integer.parseInt(orcColumn.getAttributes().get("iceberg.id"))))));
            ImmutableMap fileOrcColumnsByName = Maps.uniqueIndex(fileOrcColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            int nextMissingColumnIndex = fileOrcColumnsByName.size();
            ArrayList<Boolean> isRowPositionList = new ArrayList<Boolean>();
            for (IcebergColumnHandle column : regularColumns) {
                IcebergOrcColumn icebergOrcColumn;
                boolean isExcludeColumn = false;
                if (fileOrcColumnByIcebergId.isEmpty()) {
                    icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName());
                } else {
                    icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnByIcebergId.get(column.getId());
                    if (icebergOrcColumn == null && (icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName())) != null) {
                        isExcludeColumn = true;
                    }
                }
                if (icebergOrcColumn != null) {
                    HiveColumnHandle columnHandle = new HiveColumnHandle(column.getName(), TypeConverter.toHiveType(column.getType()), column.getType().getTypeSignature(), icebergOrcColumn.getOrcColumnId(), icebergOrcColumn.getColumnType(), Optional.empty(), Optional.empty());
                    physicalColumnHandles.add(columnHandle);
                    if (!isExcludeColumn) {
                        includedColumns.put((Object)columnHandle.getHiveColumnIndex(), (Object)typeManager.getType(columnHandle.getTypeSignature()));
                        columnReferences.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)columnHandle, columnHandle.getHiveColumnIndex(), typeManager.getType(columnHandle.getTypeSignature())));
                    }
                } else {
                    physicalColumnHandles.add(new HiveColumnHandle(column.getName(), TypeConverter.toHiveType(column.getType()), column.getType().getTypeSignature(), nextMissingColumnIndex++, IcebergPageSourceProvider.getHiveColumnHandleColumnType(column.getColumnType()), column.getComment(), column.getRequiredSubfields(), Optional.empty()));
                }
                isRowPositionList.add(column.isRowPositionColumn());
            }
            TupleDomain hiveColumnHandleTupleDomain = effectivePredicate.transform(arg_0 -> IcebergPageSourceProvider.lambda$createBatchOrcPageSource$11(fileOrcColumnByIcebergId, (Map)fileOrcColumnsByName, arg_0));
            TupleDomainOrcPredicate predicate = new TupleDomainOrcPredicate(hiveColumnHandleTupleDomain, (List)columnReferences.build(), orcBloomFiltersEnabled, Optional.of(domainCompactionThreshold));
            HiveOrcAggregatedMemoryContext systemMemoryUsage = new HiveOrcAggregatedMemoryContext();
            OrcBatchRecordReader recordReader = reader.createBatchRecordReader((Map)includedColumns.build(), (OrcPredicate)predicate, start, length, (ZoneId)ZoneOffset.UTC, (OrcAggregatedMemoryContext)systemMemoryUsage, 1);
            return new ConnectorPageSourceWithRowPositions((ConnectorPageSource)new OrcBatchPageSource(recordReader, (OrcDataSource)orcDataSource, physicalColumnHandles, typeManager, (OrcAggregatedMemoryContext)systemMemoryUsage, stats, runtimeStats, isRowPositionList), Optional.empty(), Optional.empty());
        }
        catch (Exception e) {
            if (orcDataSource != null) {
                try {
                    orcDataSource.close();
                }
                catch (IOException fileStatus) {
                    // empty catch block
                }
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static List<IcebergOrcColumn> getFileOrcColumns(OrcReader reader) {
        List orcTypes = reader.getFooter().getTypes();
        OrcType rootOrcType = (OrcType)orcTypes.get(0);
        Object columnAttributes = ImmutableList.of();
        if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            columnAttributes = (List)IntStream.range(0, rootOrcType.getFieldCount()).mapToObj(fieldId -> new IcebergOrcColumn(fieldId, rootOrcType.getFieldTypeIndex(fieldId), Optional.empty(), rootOrcType.getFieldName(fieldId), BaseHiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getAttributes())).collect(ImmutableList.toImmutableList());
        } else if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.LIST) {
            columnAttributes = ImmutableList.of((Object)new IcebergOrcColumn(0, rootOrcType.getFieldTypeIndex(0), Optional.empty(), "item", BaseHiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getAttributes()));
        } else if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.MAP) {
            columnAttributes = ImmutableList.of((Object)new IcebergOrcColumn(0, rootOrcType.getFieldTypeIndex(0), Optional.empty(), "key", BaseHiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getAttributes()), (Object)new IcebergOrcColumn(1, rootOrcType.getFieldTypeIndex(1), Optional.empty(), "value", BaseHiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(1))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(1))).getAttributes()));
        } else if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.UNION) {
            columnAttributes = (List)IntStream.range(0, rootOrcType.getFieldCount()).mapToObj(fieldId -> new IcebergOrcColumn(fieldId, rootOrcType.getFieldTypeIndex(fieldId), Optional.empty(), "field" + fieldId, BaseHiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getAttributes())).collect(ImmutableList.toImmutableList());
        }
        return columnAttributes;
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableLayoutHandle layout, List<ColumnHandle> desiredColumns, SplitContext splitContext) {
        IcebergTableLayoutHandle icebergLayout = (IcebergTableLayoutHandle)layout;
        if (icebergLayout.isPushdownFilterEnabled()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Filter Pushdown not supported for Iceberg Java Connector");
        }
        IcebergSplit split = (IcebergSplit)connectorSplit;
        IcebergTableHandle table = icebergLayout.getTable();
        List<Object> columns = desiredColumns;
        if (split.getChangelogSplitInfo().isPresent()) {
            columns = split.getChangelogSplitInfo().get().getIcebergColumns();
        }
        List icebergColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Map<Integer, HivePartitionKey> partitionKeys = split.getPartitionKeys();
        List<IcebergColumnHandle> regularColumns = columns.stream().map(IcebergColumnHandle.class::cast).filter(column -> column.getColumnType() != BaseHiveColumnHandle.ColumnType.PARTITION_KEY && !partitionKeys.containsKey(column.getId()) && !IcebergMetadataColumn.isMetadataColumnId(column.getId())).collect(Collectors.toList());
        Optional<String> tableSchemaJson = table.getTableSchemaJson();
        Verify.verify((boolean)tableSchemaJson.isPresent(), (String)"tableSchemaJson is null", (Object[])new Object[0]);
        Schema tableSchema = SchemaParser.fromJson((String)tableSchemaJson.get());
        boolean equalityDeletesRequired = table.getIcebergTableName().getTableType() == IcebergTableType.DATA;
        Set<IcebergColumnHandle> deleteFilterRequiredColumns = this.requiredColumnsForDeletes(tableSchema, split.getDeletes(), equalityDeletesRequired);
        deleteFilterRequiredColumns.stream().filter(Predicates.not(icebergColumns::contains)).forEach(regularColumns::add);
        HdfsContext hdfsContext = new HdfsContext(session, table.getSchemaName(), table.getIcebergTableName().getTableName());
        ConnectorPageSourceWithRowPositions connectorPageSourceWithRowPositions = this.createDataPageSource(session, hdfsContext, new Path(split.getPath()), split.getStart(), split.getLength(), split.getFileFormat(), regularColumns, table.getPredicate(), splitContext.isCacheable());
        ConnectorPageSource dataPageSource = connectorPageSourceWithRowPositions.getConnectorPageSource();
        com.google.common.base.Supplier deletePredicate = Suppliers.memoize(() -> {
            List deletesToApply = (List)split.getDeletes().stream().filter(deleteFile -> deleteFile.content() == FileContent.POSITION_DELETES || equalityDeletesRequired).collect(ImmutableList.toImmutableList());
            List<DeleteFilter> deleteFilters = this.readDeletes(session, tableSchema, split.getPath(), deletesToApply, connectorPageSourceWithRowPositions.getStartRowPosition(), connectorPageSourceWithRowPositions.getEndRowPosition());
            return deleteFilters.stream().map(filter -> filter.createPredicate(regularColumns)).reduce(RowPredicate::and);
        });
        HashMap<Integer, Object> metadataValues = new HashMap<Integer, Object>();
        for (IcebergColumnHandle icebergColumn : icebergColumns) {
            if (icebergColumn.isPathColumn()) {
                metadataValues.put(icebergColumn.getColumnIdentity().getId(), Slices.utf8Slice((String)split.getPath()));
                continue;
            }
            if (!icebergColumn.isDataSequenceNumberColumn()) continue;
            metadataValues.put(icebergColumn.getColumnIdentity().getId(), split.getDataSequenceNumber());
        }
        Object dataSource = new IcebergPageSource(icebergColumns, metadataValues, partitionKeys, dataPageSource, (Supplier<Optional<RowPredicate>>)deletePredicate);
        if (split.getChangelogSplitInfo().isPresent()) {
            dataSource = new ChangelogPageSource((ConnectorPageSource)dataSource, split.getChangelogSplitInfo().get(), (List<IcebergColumnHandle>)desiredColumns, icebergColumns);
        }
        return dataSource;
    }

    private Set<IcebergColumnHandle> requiredColumnsForDeletes(Schema schema, List<DeleteFile> deletes, boolean equalityDeletesRequired) {
        ImmutableSet.Builder requiredColumns = ImmutableSet.builder();
        for (DeleteFile deleteFile : deletes) {
            if (deleteFile.content() == FileContent.POSITION_DELETES) {
                requiredColumns.add((Object)IcebergColumnHandle.create(MetadataColumns.ROW_POSITION, this.typeManager, BaseHiveColumnHandle.ColumnType.REGULAR));
                continue;
            }
            if (deleteFile.content() != FileContent.EQUALITY_DELETES || !equalityDeletesRequired) continue;
            deleteFile.equalityFieldIds().stream().map(id -> IcebergColumnHandle.create(schema.findField(id.intValue()), this.typeManager, BaseHiveColumnHandle.ColumnType.REGULAR)).forEach(arg_0 -> ((ImmutableSet.Builder)requiredColumns).add(arg_0));
        }
        return requiredColumns.build();
    }

    private List<DeleteFilter> readDeletes(ConnectorSession session, Schema schema, String dataFilePath, List<DeleteFile> deleteFiles, Optional<Long> startRowPosition, Optional<Long> endRowPosition) {
        Verify.verify((startRowPosition.isPresent() == endRowPosition.isPresent() ? 1 : 0) != 0, (String)"startRowPosition and endRowPosition must be specified together", (Object[])new Object[0]);
        Slice targetPath = Slices.utf8Slice((String)dataFilePath);
        ArrayList<DeleteFilter> filters = new ArrayList<DeleteFilter>();
        Roaring64Bitmap deletedRows = new Roaring64Bitmap();
        IcebergColumnHandle deleteFilePath = IcebergColumnHandle.create(MetadataColumns.DELETE_FILE_PATH, this.typeManager, BaseHiveColumnHandle.ColumnType.REGULAR);
        IcebergColumnHandle deleteFilePos = IcebergColumnHandle.create(MetadataColumns.DELETE_FILE_POS, this.typeManager, BaseHiveColumnHandle.ColumnType.REGULAR);
        ImmutableList deleteColumns = ImmutableList.of((Object)((Object)deleteFilePath), (Object)((Object)deleteFilePos));
        TupleDomain deleteDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)((Object)deleteFilePath), (Object)NullableValue.of((com.facebook.presto.common.type.Type)VarcharType.VARCHAR, (Object)targetPath)));
        if (startRowPosition.isPresent()) {
            Range positionRange = Range.range((com.facebook.presto.common.type.Type)deleteFilePos.getType(), (Object)startRowPosition.get(), (boolean)true, (Object)endRowPosition.get(), (boolean)true);
            TupleDomain positionDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((Object)deleteFilePos), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)positionRange, (Range[])new Range[0]), (boolean)false)));
            deleteDomain = deleteDomain.intersect(positionDomain);
        }
        for (DeleteFile delete : deleteFiles) {
            if (delete.content() == FileContent.POSITION_DELETES) {
                Object positionLowerBound;
                if (startRowPosition.isPresent()) {
                    byte[] lowerBoundBytes = delete.getLowerBounds().get(MetadataColumns.DELETE_FILE_POS.fieldId());
                    positionLowerBound = Optional.ofNullable(lowerBoundBytes).map(bytes -> (Long)Conversions.fromByteBuffer((Type)MetadataColumns.DELETE_FILE_POS.type(), (ByteBuffer)ByteBuffer.wrap(bytes)));
                    byte[] upperBoundBytes = delete.getUpperBounds().get(MetadataColumns.DELETE_FILE_POS.fieldId());
                    Optional<Long> positionUpperBound = Optional.ofNullable(upperBoundBytes).map(bytes -> (Long)Conversions.fromByteBuffer((Type)MetadataColumns.DELETE_FILE_POS.type(), (ByteBuffer)ByteBuffer.wrap(bytes)));
                    if (((Optional)positionLowerBound).isPresent() && (Long)((Optional)positionLowerBound).get() > endRowPosition.get() || positionUpperBound.isPresent() && positionUpperBound.get() < startRowPosition.get()) continue;
                }
                try {
                    ConnectorPageSource pageSource = this.openDeletes(session, delete, (List<IcebergColumnHandle>)deleteColumns, (TupleDomain<IcebergColumnHandle>)deleteDomain);
                    positionLowerBound = null;
                    try {
                        PositionDeleteFilter.readPositionDeletes(pageSource, targetPath, (LongBitmapDataProvider)deletedRows);
                        continue;
                    }
                    catch (Throwable upperBoundBytes) {
                        positionLowerBound = upperBoundBytes;
                        throw upperBoundBytes;
                    }
                    finally {
                        if (pageSource == null) continue;
                        if (positionLowerBound != null) {
                            try {
                                pageSource.close();
                            }
                            catch (Throwable upperBoundBytes) {
                                ((Throwable)positionLowerBound).addSuppressed(upperBoundBytes);
                            }
                            continue;
                        }
                        pageSource.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, String.format("Cannot open Iceberg delete file: %s", delete.path()), (Throwable)e);
                }
            }
            if (delete.content() == FileContent.EQUALITY_DELETES) {
                List<Integer> fieldIds = delete.equalityFieldIds();
                Verify.verify((!fieldIds.isEmpty() ? 1 : 0) != 0, (String)"equality field IDs are missing", (Object[])new Object[0]);
                List columns = (List)fieldIds.stream().map(id -> IcebergColumnHandle.create(schema.findField(id.intValue()), this.typeManager, BaseHiveColumnHandle.ColumnType.REGULAR)).collect(ImmutableList.toImmutableList());
                try {
                    ConnectorPageSource pageSource = this.openDeletes(session, delete, columns, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
                    Throwable throwable = null;
                    try {
                        filters.add(EqualityDeleteFilter.readEqualityDeletes(pageSource, columns, schema));
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pageSource == null) continue;
                        if (throwable != null) {
                            try {
                                pageSource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pageSource.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, String.format("Cannot open Iceberg delete file: %s", delete.path()), (Throwable)e);
                }
            }
            throw new VerifyException("Unknown delete content: " + (Object)((Object)delete.content()));
        }
        if (!deletedRows.isEmpty()) {
            filters.add(new PositionDeleteFilter((ImmutableLongBitmapDataProvider)deletedRows));
        }
        return filters;
    }

    private ConnectorPageSource openDeletes(ConnectorSession session, DeleteFile delete, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> tupleDomain) {
        return this.createDataPageSource(session, new HdfsContext(session), new Path(delete.path()), 0L, delete.fileSizeInBytes(), delete.format(), columns, tupleDomain, false).getConnectorPageSource();
    }

    private ConnectorPageSourceWithRowPositions createDataPageSource(ConnectorSession session, HdfsContext hdfsContext, Path path, long start, long length, FileFormat fileFormat, List<IcebergColumnHandle> dataColumns, TupleDomain<IcebergColumnHandle> predicate, boolean isCacheable) {
        switch (fileFormat) {
            case PARQUET: {
                return IcebergPageSourceProvider.createParquetPageSource(this.hdfsEnvironment, session, this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, dataColumns, predicate, this.fileFormatDataSourceStats, this.parquetMetadataSource);
            }
            case ORC: {
                OrcReaderOptions readerOptions = OrcReaderOptions.builder().withMaxMergeDistance(HiveCommonSessionProperties.getOrcMaxMergeDistance((ConnectorSession)session)).withTinyStripeThreshold(HiveCommonSessionProperties.getOrcTinyStripeThreshold((ConnectorSession)session)).withMaxBlockSize(HiveCommonSessionProperties.getOrcMaxReadBlockSize((ConnectorSession)session)).withZstdJniDecompressionEnabled(HiveCommonSessionProperties.isOrcZstdJniDecompressionEnabled((ConnectorSession)session)).build();
                return IcebergPageSourceProvider.createBatchOrcPageSource(this.hdfsEnvironment, session.getUser(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, isCacheable, dataColumns, this.typeManager, predicate, readerOptions, OrcEncoding.ORC, HiveCommonSessionProperties.getOrcMaxBufferSize((ConnectorSession)session), HiveCommonSessionProperties.getOrcStreamBufferSize((ConnectorSession)session), HiveCommonSessionProperties.getOrcLazyReadSmallRanges((ConnectorSession)session), HiveCommonSessionProperties.isOrcBloomFiltersEnabled((ConnectorSession)session), this.hiveClientConfig.getDomainCompactionThreshold(), this.orcFileTailSource, this.stripeMetadataSourceFactory, this.fileFormatDataSourceStats, Optional.empty(), this.dwrfEncryptionProvider);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + (Object)((Object)fileFormat));
    }

    private static /* synthetic */ HiveColumnHandle lambda$createBatchOrcPageSource$11(Map fileOrcColumnByIcebergId, Map fileOrcColumnsByName, IcebergColumnHandle column) {
        IcebergOrcColumn icebergOrcColumn;
        if (fileOrcColumnByIcebergId.isEmpty()) {
            icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName());
        } else {
            icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnByIcebergId.get(column.getId());
            if (icebergOrcColumn == null) {
                icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName());
            }
        }
        return new HiveColumnHandle(column.getName(), TypeConverter.toHiveType(column.getType()), column.getType().getTypeSignature(), icebergOrcColumn != null ? icebergOrcColumn.getOrcColumnId() : column.getId() - 1, icebergOrcColumn != null ? icebergOrcColumn.getColumnType() : BaseHiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    }

    private static /* synthetic */ ParquetMetadata lambda$createParquetPageSource$0(ParquetMetadataSource parquetMetadataSource, ParquetDataSource parquetDataSource, long fileSize, HiveFileContext hiveFileContext, Optional fileDecryptor, boolean readMaskedValue) throws IOException {
        return parquetMetadataSource.getParquetMetadata(parquetDataSource, fileSize, hiveFileContext.isCacheable(), hiveFileContext.getModificationTime(), fileDecryptor, readMaskedValue).getParquetMetadata();
    }

    private static final class ConnectorPageSourceWithRowPositions {
        private final ConnectorPageSource connectorPageSource;
        private final Optional<Long> startRowPosition;
        private final Optional<Long> endRowPosition;

        public ConnectorPageSourceWithRowPositions(ConnectorPageSource connectorPageSource, Optional<Long> startRowPosition, Optional<Long> endRowPosition) {
            this.connectorPageSource = Objects.requireNonNull(connectorPageSource, "connectorPageSource is null");
            this.startRowPosition = Objects.requireNonNull(startRowPosition, "startRowPosition is null");
            this.endRowPosition = Objects.requireNonNull(endRowPosition, "endRowPosition is null");
        }

        public ConnectorPageSource getConnectorPageSource() {
            return this.connectorPageSource;
        }

        public Optional<Long> getStartRowPosition() {
            return this.startRowPosition;
        }

        public Optional<Long> getEndRowPosition() {
            return this.endRowPosition;
        }
    }
}

