/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.hive.gcs.GcsConfigurationInitializer;
import com.facebook.presto.hive.s3.S3ConfigurationUpdater;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.IcebergCatalogName;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.nessie.AuthenticationType;
import com.facebook.presto.iceberg.nessie.NessieConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.SupportsNamespaces;

public class IcebergResourceFactory {
    private final Cache<String, Catalog> catalogCache;
    private final String catalogName;
    private final CatalogType catalogType;
    private final String catalogWarehouse;
    private final List<String> hadoopConfigResources;
    private final NessieConfig nessieConfig;
    private final S3ConfigurationUpdater s3ConfigurationUpdater;
    private final GcsConfigurationInitializer gcsConfigurationInitialize;
    private final IcebergConfig icebergConfig;

    @Inject
    public IcebergResourceFactory(IcebergConfig config, IcebergCatalogName catalogName, NessieConfig nessieConfig, S3ConfigurationUpdater s3ConfigurationUpdater, GcsConfigurationInitializer gcsConfigurationInitialize) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null").getCatalogName();
        this.icebergConfig = Objects.requireNonNull(config, "config is null");
        this.catalogType = config.getCatalogType();
        this.catalogWarehouse = config.getCatalogWarehouse();
        this.hadoopConfigResources = config.getHadoopConfigResources();
        this.nessieConfig = Objects.requireNonNull(nessieConfig, "nessieConfig is null");
        this.s3ConfigurationUpdater = Objects.requireNonNull(s3ConfigurationUpdater, "s3ConfigurationUpdater is null");
        this.gcsConfigurationInitialize = Objects.requireNonNull(gcsConfigurationInitialize, "gcsConfigurationInitialize is null");
        this.catalogCache = CacheBuilder.newBuilder().maximumSize((long)config.getCatalogCacheSize()).build();
    }

    public Catalog getCatalog(ConnectorSession session) {
        try {
            return (Catalog)this.catalogCache.get((Object)this.getCatalogCacheKey(session), () -> CatalogUtil.loadCatalog((String)this.catalogType.getCatalogImpl(), (String)this.catalogName, this.getCatalogProperties(session), (Object)this.getHadoopConfiguration()));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new UncheckedExecutionException(e);
        }
    }

    public SupportsNamespaces getNamespaces(ConnectorSession session) {
        Catalog catalog = this.getCatalog(session);
        if (catalog instanceof SupportsNamespaces) {
            return (SupportsNamespaces)catalog;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg catalog of type " + (Object)((Object)this.catalogType) + " does not support namespace operations");
    }

    private String getCatalogCacheKey(ConnectorSession session) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.catalogName);
        if (this.catalogType == CatalogType.NESSIE) {
            sb.append(IcebergSessionProperties.getNessieReferenceName(session));
            sb.append("@");
            sb.append(IcebergSessionProperties.getNessieReferenceHash(session));
        }
        return sb.toString();
    }

    private Configuration getHadoopConfiguration() {
        Configuration configuration = new Configuration(false);
        if (this.hadoopConfigResources.isEmpty()) {
            configuration.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            configuration.set("fs.file.impl", LocalFileSystem.class.getName());
        }
        this.s3ConfigurationUpdater.updateConfiguration(configuration);
        this.gcsConfigurationInitialize.updateConfiguration(configuration);
        for (String resourcePath : this.hadoopConfigResources) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            for (Map.Entry entry : resourceProperties) {
                configuration.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return configuration;
    }

    public Map<String, String> getCatalogProperties(ConnectorSession session) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.icebergConfig.getManifestCachingEnabled()) {
            IcebergUtil.loadCachingProperties(properties, this.icebergConfig);
        }
        if (this.icebergConfig.getFileIOImpl() != null) {
            properties.put("io-impl", this.icebergConfig.getFileIOImpl());
        }
        if (this.catalogWarehouse != null) {
            properties.put("warehouse", this.catalogWarehouse);
        }
        if (this.catalogType == CatalogType.NESSIE) {
            properties.put("ref", IcebergSessionProperties.getNessieReferenceName(session));
            properties.put("uri", this.nessieConfig.getServerUri().orElseThrow(() -> new IllegalStateException("iceberg.nessie.uri must be set for Nessie")));
            String hash = IcebergSessionProperties.getNessieReferenceHash(session);
            if (hash != null) {
                properties.put("ref.hash", hash);
            }
            this.nessieConfig.getReadTimeoutMillis().ifPresent(val -> properties.put("transport.read-timeout", val.toString()));
            this.nessieConfig.getConnectTimeoutMillis().ifPresent(val -> properties.put("transport.connect-timeout", val.toString()));
            this.nessieConfig.getClientBuilderImpl().ifPresent(val -> properties.put("client-builder-impl", (String)val));
            this.nessieConfig.getAuthenticationType().ifPresent(type -> {
                if (type == AuthenticationType.BASIC) {
                    properties.put("authentication.username", this.nessieConfig.getUsername().orElseThrow(() -> new IllegalStateException("iceberg.nessie.auth.basic.username must be set with BASIC authentication")));
                    properties.put("authentication.password", this.nessieConfig.getPassword().orElseThrow(() -> new IllegalStateException("iceberg.nessie.auth.basic.password must be set with BASIC authentication")));
                } else if (type == AuthenticationType.BEARER) {
                    properties.put("authentication.token", this.nessieConfig.getBearerToken().orElseThrow(() -> new IllegalStateException("iceberg.nessie.auth.bearer.token must be set with BEARER authentication")));
                }
            });
            if (!this.nessieConfig.isCompressionEnabled()) {
                properties.put("transport.disable-compression", "true");
            }
        }
        return properties;
    }
}

