/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.nessie.NessieConfig;
import com.facebook.presto.iceberg.util.HiveStatisticsMergeStrategy;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;
import org.apache.parquet.column.ParquetProperties;

public final class IcebergSessionProperties {
    private static final String COMPRESSION_CODEC = "compression_codec";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String PARQUET_WRITER_VERSION = "parquet_writer_version";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE = "orc_optimized_writer_min_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE = "orc_optimized_writer_max_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS = "orc_optimized_writer_max_stripe_rows";
    private static final String ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY = "orc_optimized_writer_max_dictionary_memory";
    private static final String CACHE_ENABLED = "cache_enabled";
    private static final String MINIMUM_ASSIGNED_SPLIT_WEIGHT = "minimum_assigned_split_weight";
    private static final String NESSIE_REFERENCE_NAME = "nessie_reference_name";
    private static final String NESSIE_REFERENCE_HASH = "nessie_reference_hash";
    public static final String PARQUET_DEREFERENCE_PUSHDOWN_ENABLED = "parquet_dereference_pushdown_enabled";
    public static final String MERGE_ON_READ_MODE_ENABLED = "merge_on_read_enabled";
    public static final String PUSHDOWN_FILTER_ENABLED = "pushdown_filter_enabled";
    public static final String DELETE_AS_JOIN_REWRITE_ENABLED = "delete_as_join_rewrite_enabled";
    public static final String HIVE_METASTORE_STATISTICS_MERGE_STRATEGY = "hive_statistics_merge_strategy";
    public static final String STATISTIC_SNAPSHOT_RECORD_DIFFERENCE_WEIGHT = "statistic_snapshot_record_difference_weight";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public IcebergSessionProperties(IcebergConfig icebergConfig, ParquetFileWriterConfig parquetFileWriterConfig, OrcFileWriterConfig orcFileWriterConfig, CacheConfig cacheConfig, NessieConfig nessieConfig) {
        this.sessionProperties = ImmutableList.of((Object)new PropertyMetadata(COMPRESSION_CODEC, "The compression codec to use when writing files", (Type)VarcharType.VARCHAR, HiveCompressionCodec.class, (Object)icebergConfig.getCompressionCodec(), false, value -> HiveCompressionCodec.valueOf((String)((String)value).toUpperCase()), Enum::name), IcebergSessionProperties.dataSizeSessionProperty(PARQUET_WRITER_BLOCK_SIZE, "Parquet: Writer block size", parquetFileWriterConfig.getBlockSize(), false), IcebergSessionProperties.dataSizeSessionProperty(PARQUET_WRITER_PAGE_SIZE, "Parquet: Writer page size", parquetFileWriterConfig.getPageSize(), false), (Object)new PropertyMetadata(PARQUET_WRITER_VERSION, "Parquet: Writer version", (Type)VarcharType.VARCHAR, ParquetProperties.WriterVersion.class, (Object)parquetFileWriterConfig.getWriterVersion(), false, value -> ParquetProperties.WriterVersion.valueOf((String)((String)value).toUpperCase()), Enum::name), IcebergSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, "Experimental: ORC: Min stripe size", orcFileWriterConfig.getStripeMinSize(), false), IcebergSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, "Experimental: ORC: Max stripe size", orcFileWriterConfig.getStripeMaxSize(), false), (Object)PropertyMetadata.integerProperty((String)ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, (String)"Experimental: ORC: Max stripe row count", (Integer)orcFileWriterConfig.getStripeMaxRowCount(), (boolean)false), IcebergSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, "Experimental: ORC: Max dictionary memory", orcFileWriterConfig.getDictionaryMaxMemory(), false), (Object)PropertyMetadata.booleanProperty((String)CACHE_ENABLED, (String)"Enable cache for Iceberg", (Boolean)cacheConfig.isCachingEnabled(), (boolean)false), (Object)PropertyMetadata.doubleProperty((String)MINIMUM_ASSIGNED_SPLIT_WEIGHT, (String)"Minimum assigned split weight", (Double)icebergConfig.getMinimumAssignedSplitWeight(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)NESSIE_REFERENCE_NAME, (String)"Nessie reference name to use", (String)nessieConfig.getDefaultReferenceName(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)NESSIE_REFERENCE_HASH, (String)"Nessie reference hash to use", null, (boolean)false), (Object[])new PropertyMetadata[]{IcebergSessionProperties.dataSizeSessionProperty(ORC_STRING_STATISTICS_LIMIT, "ORC: Maximum size of string statistics; drop if exceeding", orcFileWriterConfig.getStringStatisticsLimit(), false), PropertyMetadata.booleanProperty((String)PARQUET_DEREFERENCE_PUSHDOWN_ENABLED, (String)"Is dereference pushdown expression pushdown into Parquet reader enabled?", (Boolean)icebergConfig.isParquetDereferencePushdownEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)MERGE_ON_READ_MODE_ENABLED, (String)"Reads enabled for merge-on-read Iceberg tables", (Boolean)icebergConfig.isMergeOnReadModeEnabled(), (boolean)false), new PropertyMetadata(HIVE_METASTORE_STATISTICS_MERGE_STRATEGY, "choose how to include statistics from the Hive Metastore when calculating table stats. Valid values are: " + Joiner.on((String)", ").join((Object[])HiveStatisticsMergeStrategy.values()), (Type)VarcharType.VARCHAR, HiveStatisticsMergeStrategy.class, (Object)icebergConfig.getHiveStatisticsMergeStrategy(), false, val -> HiveStatisticsMergeStrategy.valueOf((String)val), Enum::name), PropertyMetadata.booleanProperty((String)PUSHDOWN_FILTER_ENABLED, (String)"Experimental: Enable Filter Pushdown for Iceberg. This is only supported with Native Worker.", (Boolean)icebergConfig.isPushdownFilterEnabled(), (boolean)false), PropertyMetadata.doubleProperty((String)STATISTIC_SNAPSHOT_RECORD_DIFFERENCE_WEIGHT, (String)"the amount that the difference in total record count matterswhen calculating the closest snapshot when picking statistics. A value of 1 means a single record is equivalent to 1 millisecond of time difference.", (Double)icebergConfig.getStatisticSnapshotRecordDifferenceWeight(), (boolean)false), PropertyMetadata.booleanProperty((String)DELETE_AS_JOIN_REWRITE_ENABLED, (String)"When enabled equality delete row filtering will be pushed down into a join.", (Boolean)icebergConfig.isDeleteAsJoinRewriteEnabled(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static HiveCompressionCodec getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)session.getProperty(COMPRESSION_CODEC, HiveCompressionCodec.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_BLOCK_SIZE, DataSize.class);
    }

    public static ParquetProperties.WriterVersion getParquetWriterVersion(ConnectorSession session) {
        return (ParquetProperties.WriterVersion)session.getProperty(PARQUET_WRITER_VERSION, ParquetProperties.WriterVersion.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)), DataSize::toString);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static DataSize getOrcOptimizedWriterMinStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, DataSize.class);
    }

    public static DataSize getOrcOptimizedWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static int getOrcOptimizedWriterMaxStripeRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, Integer.class);
    }

    public static DataSize getOrcOptimizedWriterMaxDictionaryMemory(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, DataSize.class);
    }

    public static String getNessieReferenceName(ConnectorSession session) {
        return (String)session.getProperty(NESSIE_REFERENCE_NAME, String.class);
    }

    public static String getNessieReferenceHash(ConnectorSession session) {
        return (String)session.getProperty(NESSIE_REFERENCE_HASH, String.class);
    }

    public static double getMinimumAssignedSplitWeight(ConnectorSession session) {
        return (Double)session.getProperty(MINIMUM_ASSIGNED_SPLIT_WEIGHT, Double.class);
    }

    public static boolean isParquetDereferencePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_DEREFERENCE_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isMergeOnReadModeEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(MERGE_ON_READ_MODE_ENABLED, Boolean.class);
    }

    public static HiveStatisticsMergeStrategy getHiveStatisticsMergeStrategy(ConnectorSession session) {
        return (HiveStatisticsMergeStrategy)((Object)session.getProperty(HIVE_METASTORE_STATISTICS_MERGE_STRATEGY, HiveStatisticsMergeStrategy.class));
    }

    public static boolean isPushdownFilterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PUSHDOWN_FILTER_ENABLED, Boolean.class);
    }

    public static double getStatisticSnapshotRecordDifferenceWeight(ConnectorSession session) {
        return (Double)session.getProperty(STATISTIC_SNAPSHOT_RECORD_DIFFERENCE_WEIGHT, Double.class);
    }

    public static boolean isDeleteToJoinPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(DELETE_AS_JOIN_REWRITE_ENABLED, Boolean.class);
    }
}

