/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.changelog.ChangelogSplitInfo;
import com.facebook.presto.iceberg.delete.DeleteFile;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IcebergSplit
implements ConnectorSplit {
    private final String path;
    private final long start;
    private final long length;
    private final FileFormat fileFormat;
    private final List<HostAddress> addresses;
    private final Map<Integer, HivePartitionKey> partitionKeys;
    private final NodeSelectionStrategy nodeSelectionStrategy;
    private final SplitWeight splitWeight;
    private final List<DeleteFile> deletes;
    private final Optional<ChangelogSplitInfo> changelogSplitInfo;
    private final long dataSequenceNumber;

    @JsonCreator
    public IcebergSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileFormat") FileFormat fileFormat, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="partitionKeys") Map<Integer, HivePartitionKey> partitionKeys, @JsonProperty(value="nodeSelectionStrategy") NodeSelectionStrategy nodeSelectionStrategy, @JsonProperty(value="splitWeight") SplitWeight splitWeight, @JsonProperty(value="deletes") List<DeleteFile> deletes, @JsonProperty(value="changelogSplitInfo") Optional<ChangelogSplitInfo> changelogSplitInfo, @JsonProperty(value="dataSequenceNumber") long dataSequenceNumber) {
        Objects.requireNonNull(nodeSelectionStrategy, "nodeSelectionStrategy is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.start = start;
        this.length = length;
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.partitionKeys = Collections.unmodifiableMap(Objects.requireNonNull(partitionKeys, "partitionKeys is null"));
        this.nodeSelectionStrategy = nodeSelectionStrategy;
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        this.deletes = ImmutableList.copyOf((Collection)Objects.requireNonNull(deletes, "deletes is null"));
        this.changelogSplitInfo = Objects.requireNonNull(changelogSplitInfo, "changelogSplitInfo is null");
        this.dataSequenceNumber = dataSequenceNumber;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public Map<Integer, HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        if (this.getNodeSelectionStrategy() == NodeSelectionStrategy.SOFT_AFFINITY) {
            return nodeProvider.get(this.path, 2);
        }
        return this.addresses;
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    @JsonProperty
    public List<DeleteFile> getDeletes() {
        return this.deletes;
    }

    @JsonProperty
    public Optional<ChangelogSplitInfo> getChangelogSplitInfo() {
        return this.changelogSplitInfo;
    }

    @JsonProperty
    public long getDataSequenceNumber() {
        return this.dataSequenceNumber;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).put((Object)"nodeSelectionStrategy", (Object)this.nodeSelectionStrategy).put((Object)"splitWeight", (Object)this.splitWeight).put((Object)"changelogSplitInfo", this.changelogSplitInfo).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).addValue((Object)this.nodeSelectionStrategy).addValue((Object)this.splitWeight).addValue(this.changelogSplitInfo).toString();
    }
}

