/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.rule.FilterPushdownUtils;
import com.facebook.presto.iceberg.ExpressionConverter;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergSplitSource;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.changelog.ChangelogSplitSource;
import com.facebook.presto.iceberg.equalitydeletes.EqualityDeletesSplitSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;

public class IcebergSplitManager
implements ConnectorSplitManager {
    private final IcebergTransactionManager transactionManager;
    private final TypeManager typeManager;

    @Inject
    public IcebergSplitManager(IcebergTransactionManager transactionManager, TypeManager typeManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        IcebergTableLayoutHandle layoutHandle = (IcebergTableLayoutHandle)layout;
        IcebergTableHandle table = layoutHandle.getTable();
        if (!table.getIcebergTableName().getSnapshotId().isPresent()) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        TupleDomain predicate = IcebergSessionProperties.isPushdownFilterEnabled(session) ? layoutHandle.getPartitionColumnPredicate().transform(IcebergColumnHandle.class::cast).intersect(layoutHandle.getDomainPredicate().transform(subfield -> FilterPushdownUtils.isEntireColumn((Subfield)subfield) ? subfield.getRootName() : null).transform(layoutHandle.getPredicateColumns()::get)) : table.getPredicate();
        Table icebergTable = IcebergUtil.getIcebergTable(this.transactionManager.get(transaction), session, table.getSchemaTableName());
        if (table.getIcebergTableName().getTableType() == IcebergTableType.CHANGELOG) {
            long fromSnapshot = table.getIcebergTableName().getSnapshotId().orElseGet(() -> SnapshotUtil.oldestAncestor((Table)icebergTable).snapshotId());
            long toSnapshot = table.getIcebergTableName().getChangelogEndSnapshot().orElse(icebergTable.currentSnapshot().snapshotId());
            IncrementalChangelogScan scan = (IncrementalChangelogScan)((IncrementalChangelogScan)icebergTable.newIncrementalChangelogScan().fromSnapshotExclusive(fromSnapshot)).toSnapshot(toSnapshot);
            return new ChangelogSplitSource(session, this.typeManager, icebergTable, scan, scan.targetSplitSize());
        }
        if (table.getIcebergTableName().getTableType() == IcebergTableType.EQUALITY_DELETES) {
            CloseableIterable<DeleteFile> deleteFiles = IcebergUtil.getDeleteFiles(icebergTable, table.getIcebergTableName().getSnapshotId().get(), table.getPredicate(), table.getPartitionSpecId(), table.getEqualityFieldIds());
            return new EqualityDeletesSplitSource(session, icebergTable, deleteFiles);
        }
        TableScan tableScan = ((TableScan)icebergTable.newScan().filter(ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)predicate))).useSnapshot(table.getIcebergTableName().getSnapshotId().get().longValue());
        IcebergSplitSource splitSource = new IcebergSplitSource(session, tableScan, (CloseableIterable<FileScanTask>)TableScanUtil.splitFiles((CloseableIterable)tableScan.planFiles(), (long)tableScan.targetSplitSize()), IcebergSessionProperties.getMinimumAssignedSplitWeight(session));
        return splitSource;
    }
}

