/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergSplit;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.delete.DeleteFile;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;

public class IcebergSplitSource
implements ConnectorSplitSource {
    private CloseableIterator<FileScanTask> fileScanTaskIterator;
    private final TableScan tableScan;
    private final Closer closer = Closer.create();
    private final double minimumAssignedSplitWeight;
    private final ConnectorSession session;

    public IcebergSplitSource(ConnectorSession session, TableScan tableScan, CloseableIterable<FileScanTask> fileScanTaskIterable, double minimumAssignedSplitWeight) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableScan = Objects.requireNonNull(tableScan, "tableScan is null");
        this.fileScanTaskIterator = fileScanTaskIterable.iterator();
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        this.closer.register(this.fileScanTaskIterator);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>();
        Iterator iterator = Iterators.limit(this.fileScanTaskIterator, (int)maxSize);
        while (iterator.hasNext()) {
            FileScanTask task = (FileScanTask)iterator.next();
            splits.add(this.toIcebergSplit(task));
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
    }

    public boolean isFinished() {
        return !this.fileScanTaskIterator.hasNext();
    }

    public void close() {
        try {
            this.closer.close();
            this.fileScanTaskIterator = CloseableIterator.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ConnectorSplit toIcebergSplit(FileScanTask task) {
        return new IcebergSplit(((DataFile)task.file()).path().toString(), task.start(), task.length(), FileFormat.fromIcebergFileFormat(((DataFile)task.file()).format()), (List<HostAddress>)ImmutableList.of(), IcebergUtil.getPartitionKeys((ContentScanTask<DataFile>)task), HiveCommonSessionProperties.getNodeSelectionStrategy((ConnectorSession)this.session), SplitWeight.fromProportion((double)Math.min(Math.max((double)task.length() / (double)this.tableScan.targetSplitSize(), this.minimumAssignedSplitWeight), 1.0)), (List)task.deletes().stream().map(DeleteFile::fromIceberg).collect(ImmutableList.toImmutableList()), Optional.empty(), IcebergUtil.getDataSequenceNumber(task.file()));
    }
}

