/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.hive.BaseHiveTableHandle;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IcebergTableHandle
extends BaseHiveTableHandle {
    private final IcebergTableName icebergTableName;
    private final TupleDomain<IcebergColumnHandle> predicate;
    private final boolean snapshotSpecified;
    private final Optional<String> tableSchemaJson;
    private final Optional<Set<Integer>> partitionFieldIds;
    private final Optional<Set<Integer>> equalityFieldIds;

    @JsonCreator
    public IcebergTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="icebergTableName") IcebergTableName icebergTableName, @JsonProperty(value="snapshotSpecified") boolean snapshotSpecified, @JsonProperty(value="predicate") TupleDomain<IcebergColumnHandle> predicate, @JsonProperty(value="tableSchemaJson") Optional<String> tableSchemaJson, @JsonProperty(value="partitionFieldIds") Optional<Set<Integer>> partitionFieldIds, @JsonProperty(value="equalityFieldIds") Optional<Set<Integer>> equalityFieldIds) {
        super(schemaName, icebergTableName.getTableName());
        this.icebergTableName = Objects.requireNonNull(icebergTableName, "tableName is null");
        this.snapshotSpecified = snapshotSpecified;
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.tableSchemaJson = Objects.requireNonNull(tableSchemaJson, "tableSchemaJson is null");
        this.partitionFieldIds = Objects.requireNonNull(partitionFieldIds, "partitionFieldIds is null");
        this.equalityFieldIds = Objects.requireNonNull(equalityFieldIds, "equalityFieldIds is null");
    }

    @JsonProperty
    public IcebergTableName getIcebergTableName() {
        return this.icebergTableName;
    }

    @JsonProperty
    public boolean isSnapshotSpecified() {
        return this.snapshotSpecified;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getPredicate() {
        return this.predicate;
    }

    @JsonProperty
    public Optional<String> getTableSchemaJson() {
        return this.tableSchemaJson;
    }

    @JsonProperty
    public Optional<Set<Integer>> getPartitionSpecId() {
        return this.partitionFieldIds;
    }

    @JsonProperty
    public Optional<Set<Integer>> getEqualityFieldIds() {
        return this.equalityFieldIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IcebergTableHandle that = (IcebergTableHandle)((Object)o);
        return Objects.equals(this.getSchemaName(), that.getSchemaName()) && Objects.equals(this.icebergTableName, that.icebergTableName) && this.snapshotSpecified == that.snapshotSpecified && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.tableSchemaJson, that.tableSchemaJson) && Objects.equals(this.equalityFieldIds, that.equalityFieldIds);
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaName(), this.icebergTableName, this.predicate, this.snapshotSpecified, this.tableSchemaJson, this.equalityFieldIds);
    }

    public String toString() {
        return this.icebergTableName.toString();
    }
}

