/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.BaseHiveTableLayoutHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IcebergTableLayoutHandle
extends BaseHiveTableLayoutHandle {
    private final List<Column> dataColumns;
    private final Map<String, IcebergColumnHandle> predicateColumns;
    private final Optional<Set<IcebergColumnHandle>> requestedColumns;
    private final IcebergTableHandle table;

    @JsonCreator
    public IcebergTableLayoutHandle(@JsonProperty(value="partitionColumns") List<IcebergColumnHandle> partitionColumns, @JsonProperty(value="dataColumns") List<Column> dataColumns, @JsonProperty(value="domainPredicate") TupleDomain<Subfield> domainPredicate, @JsonProperty(value="remainingPredicate") RowExpression remainingPredicate, @JsonProperty(value="predicateColumns") Map<String, IcebergColumnHandle> predicateColumns, @JsonProperty(value="requestedColumns") Optional<Set<IcebergColumnHandle>> requestedColumns, @JsonProperty(value="pushdownFilterEnabled") boolean pushdownFilterEnabled, @JsonProperty(value="partitionColumnPredicate") TupleDomain<ColumnHandle> partitionColumnPredicate, @JsonProperty(value="table") IcebergTableHandle table) {
        this(partitionColumns.stream().map(BaseHiveColumnHandle.class::cast).collect(Collectors.toList()), dataColumns, domainPredicate, remainingPredicate, predicateColumns, requestedColumns, pushdownFilterEnabled, partitionColumnPredicate, Optional.empty(), table);
    }

    protected IcebergTableLayoutHandle(List<BaseHiveColumnHandle> partitionColumns, List<Column> dataColumns, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, Map<String, IcebergColumnHandle> predicateColumns, Optional<Set<IcebergColumnHandle>> requestedColumns, boolean pushdownFilterEnabled, TupleDomain<ColumnHandle> partitionColumnPredicate, Optional<List<HivePartition>> partitions, IcebergTableHandle table) {
        super(partitionColumns, domainPredicate, remainingPredicate, pushdownFilterEnabled, partitionColumnPredicate, partitions);
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.predicateColumns = Objects.requireNonNull(predicateColumns, "predicateColumns is null");
        this.requestedColumns = Objects.requireNonNull(requestedColumns, "requestedColumns is null");
        this.table = Objects.requireNonNull(table, "table is null");
    }

    @JsonProperty
    public List<Column> getDataColumns() {
        return this.dataColumns;
    }

    @JsonProperty
    public Map<String, IcebergColumnHandle> getPredicateColumns() {
        return this.predicateColumns;
    }

    @JsonProperty
    public Optional<Set<IcebergColumnHandle>> getRequestedColumns() {
        return this.requestedColumns;
    }

    @JsonProperty
    public IcebergTableHandle getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IcebergTableLayoutHandle that = (IcebergTableLayoutHandle)((Object)o);
        return Objects.equals(this.getDomainPredicate(), that.getDomainPredicate()) && Objects.equals(this.getRemainingPredicate(), that.getRemainingPredicate()) && Objects.equals(this.getPartitionColumns(), that.getPartitionColumns()) && Objects.equals(this.predicateColumns, that.predicateColumns) && Objects.equals(this.requestedColumns, that.requestedColumns) && Objects.equals(this.isPushdownFilterEnabled(), that.isPushdownFilterEnabled()) && Objects.equals(this.getPartitionColumnPredicate(), that.getPartitionColumnPredicate()) && Objects.equals((Object)this.table, (Object)that.table);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getDomainPredicate(), this.getRemainingPredicate(), this.predicateColumns, this.requestedColumns, this.isPushdownFilterEnabled(), this.getPartitionColumnPredicate(), this.table});
    }

    public String toString() {
        return this.table.toString();
    }

    public static class Builder {
        private List<BaseHiveColumnHandle> partitionColumns;
        private List<Column> dataColumns;
        private TupleDomain<Subfield> domainPredicate;
        private RowExpression remainingPredicate;
        private Map<String, IcebergColumnHandle> predicateColumns;
        private Optional<Set<IcebergColumnHandle>> requestedColumns;
        private boolean pushdownFilterEnabled;
        private TupleDomain<ColumnHandle> partitionColumnPredicate;
        private Optional<List<HivePartition>> partitions;
        private IcebergTableHandle table;

        public Builder setPartitionColumns(List<BaseHiveColumnHandle> partitionColumns) {
            this.partitionColumns = partitionColumns;
            return this;
        }

        public Builder setDataColumns(List<Column> dataColumns) {
            this.dataColumns = dataColumns;
            return this;
        }

        public Builder setDomainPredicate(TupleDomain<Subfield> domainPredicate) {
            this.domainPredicate = domainPredicate;
            return this;
        }

        public Builder setRemainingPredicate(RowExpression remainingPredicate) {
            this.remainingPredicate = remainingPredicate;
            return this;
        }

        public Builder setPredicateColumns(Map<String, IcebergColumnHandle> predicateColumns) {
            this.predicateColumns = predicateColumns;
            return this;
        }

        public Builder setRequestedColumns(Optional<Set<IcebergColumnHandle>> requestedColumns) {
            this.requestedColumns = requestedColumns;
            return this;
        }

        public Builder setPushdownFilterEnabled(boolean pushdownFilterEnabled) {
            this.pushdownFilterEnabled = pushdownFilterEnabled;
            return this;
        }

        public Builder setPartitionColumnPredicate(TupleDomain<ColumnHandle> partitionColumnPredicate) {
            this.partitionColumnPredicate = partitionColumnPredicate;
            return this;
        }

        public Builder setPartitions(Optional<List<HivePartition>> partitions) {
            this.partitions = partitions;
            return this;
        }

        public Builder setTable(IcebergTableHandle table) {
            this.table = table;
            return this;
        }

        public IcebergTableLayoutHandle build() {
            return new IcebergTableLayoutHandle(this.partitionColumns, this.dataColumns, this.domainPredicate, this.remainingPredicate, this.predicateColumns, this.requestedColumns, this.pushdownFilterEnabled, this.partitionColumnPredicate, this.partitions, this.table);
        }
    }
}

