/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IcebergTableName {
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?<table>[^$@]+)(?:@(?<ver1>[0-9]+))?(?:\\$(?<type>[^@]+)(?:@(?<ver2>[0-9]+))?)?");
    private final String tableName;
    private final IcebergTableType icebergTableType;
    private final Optional<Long> snapshotId;
    private final Optional<Long> changelogEndSnapshot;
    private static final Set<IcebergTableType> SYSTEM_TABLES = Sets.immutableEnumSet((Enum)IcebergTableType.FILES, (Enum[])new IcebergTableType[]{IcebergTableType.MANIFESTS, IcebergTableType.PARTITIONS, IcebergTableType.HISTORY, IcebergTableType.SNAPSHOTS, IcebergTableType.PROPERTIES});

    @JsonCreator
    public IcebergTableName(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableType") IcebergTableType icebergTableType, @JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="changelogEndSnapshot") Optional<Long> changelogEndSnapshot) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.icebergTableType = Objects.requireNonNull(icebergTableType, "tableType is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.changelogEndSnapshot = Objects.requireNonNull(changelogEndSnapshot, "changelogEndSnapshot is null");
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public IcebergTableType getTableType() {
        return this.icebergTableType;
    }

    @JsonProperty
    public Optional<Long> getChangelogEndSnapshot() {
        return this.changelogEndSnapshot;
    }

    public boolean isSystemTable() {
        return SYSTEM_TABLES.contains((Object)this.icebergTableType);
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    public String getTableNameWithType() {
        return this.tableName + "$" + this.icebergTableType.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.getTableNameWithType() + "@" + this.snapshotId;
    }

    public static IcebergTableName from(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name: " + name);
        }
        String table = match.group("table");
        String typeString = match.group("type");
        String version1 = match.group("ver1");
        String version2 = match.group("ver2");
        IcebergTableType type = IcebergTableType.DATA;
        if (typeString != null) {
            try {
                type = IcebergTableType.valueOf(typeString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Iceberg table name (unknown type '%s'): %s", typeString, name));
            }
        }
        if (!type.isPublic()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Internal Iceberg table name (type '%s'): %s", typeString, name));
        }
        Optional<Long> version = Optional.empty();
        Optional<Long> changelogEndVersion = Optional.empty();
        if (type == IcebergTableType.DATA || type == IcebergTableType.PARTITIONS || type == IcebergTableType.MANIFESTS || type == IcebergTableType.FILES) {
            if (version1 != null && version2 != null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name (cannot specify two @ versions): " + name);
            }
            if (version1 != null) {
                version = Optional.of(Long.parseLong(version1));
            } else if (version2 != null) {
                version = Optional.of(Long.parseLong(version2));
            }
        } else if (type == IcebergTableType.CHANGELOG) {
            version = Optional.ofNullable(version1).map(Long::parseLong);
            changelogEndVersion = Optional.ofNullable(version2).map(Long::parseLong);
        } else if (version1 != null || version2 != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Iceberg table name (cannot use @ version with table type '%s'): %s", new Object[]{type, name}));
        }
        return new IcebergTableName(table, type, version, changelogEndVersion);
    }
}

