/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;

public class IcebergTableProperties {
    public static final String FILE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONING_PROPERTY = "partitioning";
    public static final String LOCATION_PROPERTY = "location";
    public static final String FORMAT_VERSION = "format_version";
    private final List<PropertyMetadata<?>> tableProperties;
    private final List<PropertyMetadata<?>> columnProperties;

    @Inject
    public IcebergTableProperties(IcebergConfig icebergConfig) {
        this.tableProperties = ImmutableList.builder().add((Object)new PropertyMetadata(FILE_FORMAT_PROPERTY, "File format for the table", (Type)VarcharType.createUnboundedVarcharType(), FileFormat.class, (Object)icebergConfig.getFileFormat(), false, value -> FileFormat.valueOf(((String)value).toUpperCase(Locale.ENGLISH)), value -> value.toString())).add((Object)new PropertyMetadata(PARTITIONING_PROPERTY, "Partition transforms", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).add((Object)PropertyMetadata.stringProperty((String)LOCATION_PROPERTY, (String)"File system location URI for the table", null, (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)FORMAT_VERSION, (String)"Format version for the table", null, (boolean)false)).build();
        this.columnProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)PARTITIONING_PROPERTY, (String)"This column's partition transform", null, (boolean)false));
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public static FileFormat getFileFormat(Map<String, Object> tableProperties) {
        return (FileFormat)((Object)tableProperties.get(FILE_FORMAT_PROPERTY));
    }

    public static List<String> getPartitioning(Map<String, Object> tableProperties) {
        List partitioning = (List)tableProperties.get(PARTITIONING_PROPERTY);
        return partitioning == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitioning);
    }

    public static String getTableLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(LOCATION_PROPERTY);
    }

    public static String getFormatVersion(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(FORMAT_VERSION);
    }
}

