/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.iceberg.ExpressionConverter;
import com.facebook.presto.iceberg.FileContent;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.HiveTableOperations;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.util.IcebergPrestoModelConverters;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.joda.time.DateTimeZone;

public final class IcebergUtil {
    private static final Pattern SIMPLE_NAME = Pattern.compile("[a-z][a-z0-9]*");
    private static final Logger log = Logger.get(IcebergUtil.class);

    private IcebergUtil() {
    }

    public static boolean isIcebergTable(Table table) {
        return "iceberg".equalsIgnoreCase((String)table.getParameters().get("table_type"));
    }

    public static org.apache.iceberg.Table getIcebergTable(ConnectorMetadata metadata, ConnectorSession session, SchemaTableName table) {
        Preconditions.checkArgument((boolean)(metadata instanceof IcebergAbstractMetadata), (Object)"metadata must be instance of IcebergAbstractMetadata!");
        IcebergAbstractMetadata icebergMetadata = (IcebergAbstractMetadata)metadata;
        return icebergMetadata.getIcebergTable(session, table);
    }

    public static org.apache.iceberg.Table getHiveIcebergTable(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, ConnectorSession session, SchemaTableName table) {
        HdfsContext hdfsContext = new HdfsContext(session, table.getSchemaName(), table.getTableName());
        HiveTableOperations operations = new HiveTableOperations(metastore, new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, session.getWarningCollector()), hdfsEnvironment, hdfsContext, table.getSchemaName(), table.getTableName());
        return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table));
    }

    public static org.apache.iceberg.Table getNativeIcebergTable(IcebergResourceFactory resourceFactory, ConnectorSession session, SchemaTableName table) {
        return resourceFactory.getCatalog(session).loadTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(table));
    }

    public static List<IcebergColumnHandle> getPartitionKeyColumnHandles(org.apache.iceberg.Table table, TypeManager typeManager) {
        ImmutableList.Builder partitionColumns = ImmutableList.builder();
        List<IcebergColumnHandle> allColumns = IcebergUtil.getColumns(table.schema(), table.spec(), typeManager);
        for (int i = 0; i < table.spec().fields().size(); ++i) {
            PartitionField field = (PartitionField)table.spec().fields().get(i);
            if (!field.transform().toString().equals("identity")) continue;
            Optional<IcebergColumnHandle> columnHandle = allColumns.stream().filter(icebergColumnHandle -> Objects.equals(icebergColumnHandle.getName(), field.name())).findAny();
            columnHandle.ifPresent(arg_0 -> ((ImmutableList.Builder)partitionColumns).add(arg_0));
        }
        return partitionColumns.build();
    }

    public static Optional<Long> resolveSnapshotIdByName(org.apache.iceberg.Table table, IcebergTableName name) {
        if (name.getSnapshotId().isPresent()) {
            if (table.snapshot(name.getSnapshotId().get().longValue()) == null) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, String.format("Invalid snapshot [%s] for table: %s", name.getSnapshotId().get(), table));
            }
            return name.getSnapshotId();
        }
        if (name.getTableType() == IcebergTableType.CHANGELOG) {
            return Optional.ofNullable(SnapshotUtil.oldestAncestor((org.apache.iceberg.Table)table)).map(Snapshot::snapshotId);
        }
        return IcebergUtil.tryGetCurrentSnapshot(table).map(Snapshot::snapshotId);
    }

    public static long getSnapshotIdAsOfTime(org.apache.iceberg.Table table, long millisUtc) {
        return table.history().stream().filter(logEntry -> logEntry.timestampMillis() <= millisUtc).max(Comparator.comparing(HistoryEntry::timestampMillis)).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_TABLE_TIMESTAMP, String.format("No history found based on timestamp for table %s", table.name()))).snapshotId();
    }

    public static List<IcebergColumnHandle> getColumns(Schema schema, PartitionSpec partitionSpec, TypeManager typeManager) {
        ArrayList<String> partitionFieldNames = new ArrayList<String>();
        for (int i = 0; i < partitionSpec.fields().size(); ++i) {
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            if (!field.transform().toString().equals("identity")) continue;
            partitionFieldNames.add(field.name());
        }
        return (List)schema.columns().stream().map(column -> partitionFieldNames.contains(column.name()) ? IcebergColumnHandle.create(column, typeManager, BaseHiveColumnHandle.ColumnType.PARTITION_KEY) : IcebergColumnHandle.create(column, typeManager, BaseHiveColumnHandle.ColumnType.REGULAR)).collect(ImmutableList.toImmutableList());
    }

    public static Map<PartitionField, Integer> getIdentityPartitions(PartitionSpec partitionSpec) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (int i = 0; i < partitionSpec.fields().size(); ++i) {
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            if (!field.transform().toString().equals("identity")) continue;
            columns.put((Object)field, (Object)i);
        }
        return columns.build();
    }

    public static List<Column> toHiveColumns(List<Types.NestedField> columns) {
        return (List)columns.stream().map(column -> new Column(column.name(), HiveType.toHiveType((TypeInfo)HiveSchemaUtil.convert((Type)column.type())), Optional.empty(), Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    public static FileFormat getFileFormat(org.apache.iceberg.Table table) {
        return FileFormat.valueOf(table.properties().getOrDefault("write.format.default", "parquet").toUpperCase(Locale.ENGLISH));
    }

    public static Optional<String> getTableComment(org.apache.iceberg.Table table) {
        return Optional.ofNullable(table.properties().get("comment"));
    }

    private static String quotedTableName(SchemaTableName name) {
        return IcebergUtil.quotedName(name.getSchemaName()) + "." + IcebergUtil.quotedName(name.getTableName());
    }

    private static String quotedName(String name) {
        if (SIMPLE_NAME.matcher(name).matches()) {
            return name;
        }
        return '\"' + name.replace("\"", "\"\"") + '\"';
    }

    public static TableScan getTableScan(TupleDomain<IcebergColumnHandle> predicates, Optional<Long> snapshotId, org.apache.iceberg.Table icebergTable) {
        Expression expression = ExpressionConverter.toIcebergExpression(predicates);
        TableScan tableScan = (TableScan)icebergTable.newScan().filter(expression);
        return snapshotId.map(id -> IcebergUtil.isSnapshot(icebergTable, id) ? tableScan.useSnapshot(id.longValue()) : tableScan.asOfTime(id.longValue())).orElse(tableScan);
    }

    private static boolean isSnapshot(org.apache.iceberg.Table icebergTable, Long id) {
        return Streams.stream((Iterable)icebergTable.snapshots()).anyMatch(snapshot -> snapshot.snapshotId() == id.longValue());
    }

    public static LocationProvider getLocationProvider(SchemaTableName schemaTableName, String tableLocation, Map<String, String> storageProperties) {
        if (storageProperties.containsKey("write.location-provider.impl")) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + schemaTableName + " specifies " + storageProperties.get("write.location-provider.impl") + " as a location provider. Writing to Iceberg tables with custom location provider is not supported.");
        }
        return LocationProviders.locationsFor((String)tableLocation, storageProperties);
    }

    public static TableScan buildTableScan(org.apache.iceberg.Table icebergTable, MetadataTableType metadataTableType) {
        return MetadataTableUtils.createMetadataTableInstance((org.apache.iceberg.Table)icebergTable, (MetadataTableType)metadataTableType).newScan();
    }

    public static Map<String, Integer> columnNameToPositionInSchema(Schema schema) {
        return (Map)Streams.mapWithIndex(schema.columns().stream(), (column, position) -> Maps.immutableEntry((Object)column.name(), (Object)Math.toIntExact(position))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void validateTableMode(ConnectorSession session, org.apache.iceberg.Table table) {
        if (IcebergSessionProperties.isMergeOnReadModeEnabled(session)) {
            return;
        }
        String deleteMode = (String)table.properties().get("write.delete.mode");
        String mergeMode = (String)table.properties().get("write.merge.mode");
        String updateMode = (String)table.properties().get("write.update.mode");
        if (Stream.of(deleteMode, mergeMode, updateMode).anyMatch(s -> Objects.equals(s, RowLevelOperationMode.MERGE_ON_READ.modeName()))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "merge-on-read table mode not supported yet");
        }
    }

    public static Map<String, String> createIcebergViewProperties(ConnectorSession session, String prestoVersion) {
        return ImmutableMap.builder().put((Object)"comment", (Object)"Presto View").put((Object)"presto_view", (Object)"true").put((Object)"presto_version", (Object)prestoVersion).put((Object)"presto_query_id", (Object)session.getQueryId()).put((Object)"table_type", (Object)"iceberg").build();
    }

    public static Optional<Map<String, String>> tryGetProperties(org.apache.iceberg.Table table) {
        try {
            return Optional.ofNullable(table.properties());
        }
        catch (TableNotFoundException e) {
            log.warn(String.format("Unable to fetch properties for table %s: %s", table.name(), e.getMessage()));
            return Optional.empty();
        }
    }

    public static Optional<Snapshot> tryGetCurrentSnapshot(org.apache.iceberg.Table table) {
        try {
            return Optional.ofNullable(table.currentSnapshot());
        }
        catch (TableNotFoundException e) {
            log.warn(String.format("Unable to fetch snapshot for table %s: %s", table.name(), e.getMessage()));
            return Optional.empty();
        }
    }

    private static boolean isValidPartitionType(com.facebook.presto.common.type.Type type) {
        return type instanceof DecimalType || BooleanType.BOOLEAN.equals((Object)type) || TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || RealType.REAL.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type) || DateType.DATE.equals((Object)type) || TimestampType.TIMESTAMP.equals((Object)type) || VarbinaryType.VARBINARY.equals((Object)type) || Varchars.isVarcharType((com.facebook.presto.common.type.Type)type) || Chars.isCharType((com.facebook.presto.common.type.Type)type);
    }

    private static void verifyPartitionTypeSupported(String partitionName, com.facebook.presto.common.type.Type type) {
        if (!IcebergUtil.isValidPartitionType(type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type [%s] for partition: %s", type, partitionName));
        }
    }

    private static NullableValue parsePartitionValue(String partitionName, String value, com.facebook.presto.common.type.Type type, DateTimeZone timeZone) {
        IcebergUtil.verifyPartitionTypeSupported(partitionName, type);
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)decimalType);
            }
            if (decimalType.isShort()) {
                if (value.isEmpty()) {
                    return NullableValue.of((com.facebook.presto.common.type.Type)decimalType, (Object)0L);
                }
                return NullableValue.of((com.facebook.presto.common.type.Type)decimalType, (Object)HiveUtil.shortDecimalPartitionKey((String)value, (DecimalType)decimalType, (String)partitionName));
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)decimalType, (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.ZERO));
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)decimalType, (Object)HiveUtil.longDecimalPartitionKey((String)value, (DecimalType)decimalType, (String)partitionName));
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)BooleanType.BOOLEAN);
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)BooleanType.BOOLEAN, (Object)false);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)BooleanType.BOOLEAN, (Object)HiveUtil.booleanPartitionKey((String)value, (String)partitionName));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)TinyintType.TINYINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)TinyintType.TINYINT, (Object)0L);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)TinyintType.TINYINT, (Object)HiveUtil.tinyintPartitionKey((String)value, (String)partitionName));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)SmallintType.SMALLINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)SmallintType.SMALLINT, (Object)0L);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)SmallintType.SMALLINT, (Object)HiveUtil.smallintPartitionKey((String)value, (String)partitionName));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)IntegerType.INTEGER);
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)IntegerType.INTEGER, (Object)0L);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)IntegerType.INTEGER, (Object)HiveUtil.integerPartitionKey((String)value, (String)partitionName));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)BigintType.BIGINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)BigintType.BIGINT, (Object)0L);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)BigintType.BIGINT, (Object)HiveUtil.bigintPartitionKey((String)value, (String)partitionName));
        }
        if (DateType.DATE.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)DateType.DATE);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)DateType.DATE, (Object)HiveUtil.datePartitionKey((String)value, (String)partitionName));
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)TimestampType.TIMESTAMP);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)TimestampType.TIMESTAMP, (Object)HiveUtil.timestampPartitionKey((String)value, (DateTimeZone)timeZone, (String)partitionName));
        }
        if (RealType.REAL.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)RealType.REAL);
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)RealType.REAL, (Object)Float.floatToRawIntBits(0.0f));
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)RealType.REAL, (Object)HiveUtil.floatPartitionKey((String)value, (String)partitionName));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)DoubleType.DOUBLE);
            }
            if (value.isEmpty()) {
                return NullableValue.of((com.facebook.presto.common.type.Type)DoubleType.DOUBLE, (Object)0.0);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)DoubleType.DOUBLE, (Object)HiveUtil.doublePartitionKey((String)value, (String)partitionName));
        }
        if (Varchars.isVarcharType((com.facebook.presto.common.type.Type)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)type);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)type, (Object)HiveUtil.varcharPartitionKey((String)value, (String)partitionName, (com.facebook.presto.common.type.Type)type));
        }
        if (Chars.isCharType((com.facebook.presto.common.type.Type)type)) {
            if (value == null) {
                return NullableValue.asNull((com.facebook.presto.common.type.Type)type);
            }
            return NullableValue.of((com.facebook.presto.common.type.Type)type, (Object)HiveUtil.charPartitionKey((String)value, (String)partitionName, (com.facebook.presto.common.type.Type)type));
        }
        throw new VerifyException(String.format("Unhandled type [%s] for partition: %s", type, partitionName));
    }

    public static List<HivePartition> getPartitions(TypeManager typeManager, ConnectorTableHandle tableHandle, org.apache.iceberg.Table icebergTable, Constraint<ColumnHandle> constraint, List<IcebergColumnHandle> partitionColumns) {
        IcebergTableName name = ((IcebergTableHandle)tableHandle).getIcebergTableName();
        Optional<Long> snapshotId = IcebergUtil.resolveSnapshotIdByName(icebergTable, name);
        if (!snapshotId.isPresent()) {
            return ImmutableList.of();
        }
        TableScan tableScan = ((TableScan)icebergTable.newScan().filter(ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)constraint.getSummary().simplify().transform(IcebergColumnHandle.class::cast)))).useSnapshot(snapshotId.get().longValue());
        HashSet<HivePartition> partitions = new HashSet<HivePartition>();
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            for (FileScanTask fileScanTask : fileScanTasks) {
                StructLike partition = ((DataFile)fileScanTask.file()).partition();
                PartitionSpec spec = fileScanTask.spec();
                Map<PartitionField, Integer> fieldToIndex = IcebergUtil.getIdentityPartitions(spec);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                fieldToIndex.forEach((field, index) -> {
                    int id = field.sourceId();
                    Type type = spec.schema().findType(id);
                    Class javaClass = type.typeId().javaClass();
                    Object value = partition.get(index.intValue(), javaClass);
                    String partitionStringValue = value == null ? null : (type.typeId() == Type.TypeID.FIXED || type.typeId() == Type.TypeID.BINARY ? Base64.getEncoder().encodeToString(((ByteBuffer)value).array()) : value.toString());
                    NullableValue partitionValue = IcebergUtil.parsePartitionValue(partition.toString(), partitionStringValue, TypeConverter.toPrestoType(type, typeManager), DateTimeZone.UTC);
                    Optional<IcebergColumnHandle> column = partitionColumns.stream().filter(icebergColumnHandle -> Objects.equals(icebergColumnHandle.getName(), field.name())).findAny();
                    builder.put((Object)column.get(), (Object)partitionValue);
                });
                ImmutableMap values = builder.build();
                HivePartition newPartition = new HivePartition(((IcebergTableHandle)tableHandle).getSchemaTableName(), partition.toString(), (Map)values);
                boolean isIncludePartition = true;
                Map domains = (Map)constraint.getSummary().getDomains().get();
                for (IcebergColumnHandle column : partitionColumns) {
                    NullableValue value = (NullableValue)newPartition.getKeys().get((Object)column);
                    Domain allowedDomain = (Domain)domains.get((Object)column);
                    if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
                    isIncludePartition = false;
                    break;
                }
                if (constraint.predicate().isPresent() && !((Predicate)constraint.predicate().get()).test(newPartition.getKeys())) {
                    isIncludePartition = false;
                }
                if (!isIncludePartition) continue;
                partitions.add(newPartition);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new ArrayList<HivePartition>(partitions);
    }

    public static Optional<Schema> tryGetSchema(org.apache.iceberg.Table table) {
        try {
            return Optional.ofNullable(table.schema());
        }
        catch (TableNotFoundException e) {
            log.warn(String.format("Unable to fetch schema for table %s: %s", table.name(), e.getMessage()));
            return Optional.empty();
        }
    }

    public static Schema schemaFromHandles(List<IcebergColumnHandle> columns) {
        List icebergColumns = (List)columns.stream().map(column -> Types.NestedField.optional((int)column.getId(), (String)column.getName(), (Type)TypeConverter.toIcebergType(column.getType()))).collect(ImmutableList.toImmutableList());
        return new Schema(Types.StructType.of((List)icebergColumns).asStructType().fields());
    }

    public static Object deserializePartitionValue(com.facebook.presto.common.type.Type type, String valueString, String name) {
        if (valueString == null) {
            return null;
        }
        try {
            if (type.equals(BooleanType.BOOLEAN)) {
                if (valueString.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return false;
                }
                throw new IllegalArgumentException();
            }
            if (type.equals(IntegerType.INTEGER)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(BigintType.BIGINT)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(RealType.REAL)) {
                return (long)Float.floatToRawIntBits(Float.parseFloat(valueString));
            }
            if (type.equals(DoubleType.DOUBLE)) {
                return Double.parseDouble(valueString);
            }
            if (type.equals(DateType.DATE) || type.equals(TimeType.TIME) || type.equals(TimestampType.TIMESTAMP)) {
                return Long.parseLong(valueString);
            }
            if (type instanceof VarcharType) {
                return Slices.utf8Slice((String)valueString);
            }
            if (type.equals(VarbinaryType.VARBINARY)) {
                return Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(valueString));
            }
            if (Decimals.isShortDecimal((com.facebook.presto.common.type.Type)type) || Decimals.isLongDecimal((com.facebook.presto.common.type.Type)type)) {
                DecimalType decimalType = (DecimalType)type;
                BigDecimal decimal = new BigDecimal(valueString);
                Preconditions.checkArgument(((decimal = decimal.setScale(decimalType.getScale(), 7)).precision() <= decimalType.getPrecision() ? 1 : 0) != 0);
                BigInteger unscaledValue = decimal.unscaledValue();
                return Decimals.isShortDecimal((com.facebook.presto.common.type.Type)type) ? Long.valueOf(unscaledValue.longValue()) : Decimals.encodeUnscaledValue((BigInteger)unscaledValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", valueString, type.getDisplayName(), name));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid partition type " + type.toString());
    }

    public static Map<Integer, HivePartitionKey> getPartitionKeys(ContentScanTask<DataFile> scanTask) {
        StructLike partition = ((DataFile)scanTask.file()).partition();
        PartitionSpec spec = scanTask.spec();
        return IcebergUtil.getPartitionKeys(spec, partition);
    }

    public static Map<Integer, HivePartitionKey> getPartitionKeys(PartitionSpec spec, StructLike partition) {
        HashMap<Integer, HivePartitionKey> partitionKeys = new HashMap<Integer, HivePartitionKey>();
        int index = 0;
        for (PartitionField field : spec.fields()) {
            int sourceId = field.sourceId();
            String colName = field.name();
            Type sourceType = spec.schema().findType(sourceId);
            Type type = field.transform().getResultType(sourceType);
            Class javaClass = type.typeId().javaClass();
            Object value = partition.get(index, javaClass);
            if (value == null) {
                partitionKeys.put(field.fieldId(), new HivePartitionKey(colName, Optional.empty()));
            } else {
                HivePartitionKey partitionValue = type.typeId() == Type.TypeID.FIXED || type.typeId() == Type.TypeID.BINARY ? new HivePartitionKey(colName, Optional.of(Base64.getEncoder().encodeToString(((ByteBuffer)value).array()))) : new HivePartitionKey(colName, Optional.of(value.toString()));
                partitionKeys.put(field.fieldId(), partitionValue);
                if (field.transform().isIdentity()) {
                    partitionKeys.put(sourceId, partitionValue);
                }
            }
            ++index;
        }
        return Collections.unmodifiableMap(partitionKeys);
    }

    public static void loadCachingProperties(Map<String, String> properties, IcebergConfig icebergConfig) {
        properties.put("io.manifest.cache-enabled", "true");
        properties.put("io.manifest.cache.max-total-bytes", String.valueOf(icebergConfig.getMaxManifestCacheSize()));
        properties.put("io.manifest.cache.max-content-length", String.valueOf(icebergConfig.getManifestCacheMaxContentLength()));
        properties.put("io.manifest.cache.expiration-interval-ms", String.valueOf(icebergConfig.getManifestCacheExpireDuration()));
    }

    public static long getDataSequenceNumber(ContentFile<?> file) {
        if (file.dataSequenceNumber() != null) {
            return file.dataSequenceNumber();
        }
        return file.fileSequenceNumber();
    }

    public static CloseableIterable<DeleteFile> getDeleteFiles(final org.apache.iceberg.Table table, long snapshot, TupleDomain<IcebergColumnHandle> filter, final Optional<Set<Integer>> requestedPartitionSpec, final Optional<Set<Integer>> requestedSchema) {
        Expression filterExpression = ExpressionConverter.toIcebergExpression(filter);
        final CloseableIterable fileTasks = ((TableScan)table.newScan().useSnapshot(snapshot).filter(filterExpression)).planFiles();
        return new CloseableIterable<DeleteFile>(){

            public void close() throws IOException {
                fileTasks.close();
            }

            public CloseableIterator<DeleteFile> iterator() {
                return new DeleteFilesIterator(table.specs(), fileTasks.iterator(), requestedPartitionSpec, requestedSchema);
            }
        };
    }

    private static class DeleteFilesIterator
    implements CloseableIterator<DeleteFile> {
        private final Set<String> seenFiles = new HashSet<String>();
        private final Map<Integer, PartitionSpec> partitionSpecsById;
        private CloseableIterator<FileScanTask> fileTasks;
        private final Optional<Set<Integer>> requestedPartitionSpec;
        private final Optional<Set<Integer>> requestedSchema;
        private Iterator<DeleteFile> currentDeletes = Collections.emptyIterator();
        private DeleteFile currentFile;

        private DeleteFilesIterator(Map<Integer, PartitionSpec> partitionSpecsById, CloseableIterator<FileScanTask> fileTasks, Optional<Set<Integer>> requestedPartitionSpec, Optional<Set<Integer>> requestedSchema) {
            this.partitionSpecsById = partitionSpecsById;
            this.fileTasks = fileTasks;
            this.requestedPartitionSpec = requestedPartitionSpec;
            this.requestedSchema = requestedSchema;
        }

        public boolean hasNext() {
            return this.currentFile != null || this.advance();
        }

        private boolean advance() {
            this.currentFile = null;
            while (this.currentFile == null && (this.currentDeletes.hasNext() || this.fileTasks.hasNext())) {
                if (!this.currentDeletes.hasNext()) {
                    this.currentDeletes = ((FileScanTask)this.fileTasks.next()).deletes().iterator();
                }
                while (this.currentDeletes.hasNext()) {
                    DeleteFile deleteFile = this.currentDeletes.next();
                    if (!this.shouldIncludeFile(deleteFile) || !this.seenFiles.add(deleteFile.path().toString())) continue;
                    this.currentFile = deleteFile;
                    return true;
                }
            }
            return false;
        }

        public DeleteFile next() {
            DeleteFile result = this.currentFile;
            this.advance();
            return result;
        }

        private boolean shouldIncludeFile(DeleteFile file) {
            boolean matchesPartition = !this.requestedPartitionSpec.isPresent() || this.requestedPartitionSpec.get().equals(this.partitionSpecsById.get(file.specId()).fields().stream().map(PartitionField::fieldId).collect(Collectors.toSet()));
            return matchesPartition && (FileContent.fromIcebergFileContent(file.content()) == FileContent.POSITION_DELETES || !this.requestedSchema.isPresent() || this.requestedSchema.get().equals(ImmutableSet.copyOf((Collection)file.equalityFieldIds())));
        }

        public void close() throws IOException {
            this.fileTasks.close();
            this.fileTasks = CloseableIterator.empty();
        }
    }
}

