/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IcebergWritableTableHandle
implements ConnectorInsertTableHandle,
ConnectorOutputTableHandle {
    private final String schemaName;
    private final IcebergTableName tableName;
    private final String schemaAsJson;
    private final String partitionSpecAsJson;
    private final List<IcebergColumnHandle> inputColumns;
    private final String outputPath;
    private final FileFormat fileFormat;
    private final Map<String, String> storageProperties;

    @JsonCreator
    public IcebergWritableTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") IcebergTableName tableName, @JsonProperty(value="schemaAsJson") String schemaAsJson, @JsonProperty(value="partitionSpecAsJson") String partitionSpecAsJson, @JsonProperty(value="inputColumns") List<IcebergColumnHandle> inputColumns, @JsonProperty(value="outputPath") String outputPath, @JsonProperty(value="fileFormat") FileFormat fileFormat, @JsonProperty(value="storageProperties") Map<String, String> storageProperties) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.schemaAsJson = Objects.requireNonNull(schemaAsJson, "schemaAsJson is null");
        this.partitionSpecAsJson = Objects.requireNonNull(partitionSpecAsJson, "partitionSpecAsJson is null");
        this.inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        this.outputPath = Objects.requireNonNull(outputPath, "filePrefix is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.storageProperties = Objects.requireNonNull(storageProperties, "storageProperties is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public IcebergTableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getSchemaAsJson() {
        return this.schemaAsJson;
    }

    @JsonProperty
    public String getPartitionSpecAsJson() {
        return this.partitionSpecAsJson;
    }

    @JsonProperty
    public List<IcebergColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public String getOutputPath() {
        return this.outputPath;
    }

    @JsonProperty
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public Map<String, String> getStorageProperties() {
        return this.storageProperties;
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }
}

