/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.event.client.EventModule;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.cache.CachingModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveCommonModule;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.RebindSafeMBeanServer;
import com.facebook.presto.hive.authentication.HiveAuthenticationModule;
import com.facebook.presto.hive.gcs.HiveGcsModule;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.s3.HiveS3Module;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.IcebergCommonModule;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergConnector;
import com.facebook.presto.iceberg.IcebergHiveModule;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.iceberg.IcebergNativeModule;
import com.facebook.presto.iceberg.IcebergSchemaProperties;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableProperties;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.plugin.base.security.AllowAllAccessControl;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeNodePartitioningProvider;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Types;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public final class InternalIcebergConnectorFactory {
    private InternalIcebergConnectorFactory() {
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Optional<ExtendedHiveMetastore> metastore) {
        ClassLoader classLoader = InternalIcebergConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new JsonModule(), new IcebergCommonModule(catalogName), ConditionalModule.installModuleIf(IcebergConfig.class, conf -> conf.getCatalogType().equals((Object)CatalogType.HIVE), (Module)new IcebergHiveModule(catalogName, metastore), (Module)new IcebergNativeModule()), new HiveS3Module(catalogName), new HiveGcsModule(), new HiveAuthenticationModule(), new CachingModule(), new HiveCommonModule(), binder -> {
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(platformMBeanServer));
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(StandardFunctionResolution.class).toInstance((Object)context.getStandardFunctionResolution());
                binder.bind(FunctionMetadataManager.class).toInstance((Object)context.getFunctionMetadataManager());
                binder.bind(RowExpressionService.class).toInstance((Object)context.getRowExpressionService());
                binder.bind(FilterStatsCalculatorService.class).toInstance((Object)context.getFilterStatsCalculatorService());
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            IcebergTransactionManager transactionManager = (IcebergTransactionManager)injector.getInstance(IcebergTransactionManager.class);
            IcebergMetadataFactory metadataFactory = (IcebergMetadataFactory)injector.getInstance(IcebergMetadataFactory.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            IcebergSessionProperties icebergSessionProperties = (IcebergSessionProperties)injector.getInstance(IcebergSessionProperties.class);
            HiveCommonSessionProperties hiveCommonSessionProperties = (HiveCommonSessionProperties)injector.getInstance(HiveCommonSessionProperties.class);
            IcebergTableProperties icebergTableProperties = (IcebergTableProperties)injector.getInstance(IcebergTableProperties.class);
            Set procedures = (Set)injector.getInstance(Key.get((Type)Types.setOf(Procedure.class)));
            ConnectorPlanOptimizerProvider planOptimizerProvider = (ConnectorPlanOptimizerProvider)injector.getInstance(ConnectorPlanOptimizerProvider.class);
            ArrayList allSessionProperties = new ArrayList(icebergSessionProperties.getSessionProperties());
            allSessionProperties.addAll(hiveCommonSessionProperties.getSessionProperties());
            IcebergConnector icebergConnector = new IcebergConnector(lifeCycleManager, transactionManager, metadataFactory, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), (Set<SystemTable>)ImmutableSet.of(), allSessionProperties, IcebergSchemaProperties.SCHEMA_PROPERTIES, icebergTableProperties.getTableProperties(), icebergTableProperties.getColumnProperties(), (ConnectorAccessControl)new AllowAllAccessControl(), procedures, planOptimizerProvider);
            return icebergConnector;
        }
    }
}

