/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.util.LocationUtil;

public class RegisterTableProcedure
implements Provider<Procedure> {
    private static final MethodHandle REGISTER_TABLE = MethodHandleUtil.methodHandle(RegisterTableProcedure.class, (String)"registerTable", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, String.class, String.class});
    private final IcebergMetadataFactory metadataFactory;
    private final HdfsEnvironment hdfsEnvironment;
    public static final String METADATA_FOLDER_NAME = "metadata";
    private static final String METADATA_FILE_EXTENSION = ".metadata.json";
    private static final Pattern METADATA_VERSION_PATTERN = Pattern.compile("(?<version>\\d+)-(?<uuid>[-a-fA-F0-9]*)(?<compression>\\.[a-zA-Z0-9]+)?" + Pattern.quote(".metadata.json") + "(?<compression2>\\.[a-zA-Z0-9]+)?");
    private static final Pattern HADOOP_METADATA_VERSION_PATTERN = Pattern.compile("v(?<version>\\d+)(?<compression>\\.[a-zA-Z0-9]+)?" + Pattern.quote(".metadata.json") + "(?<compression2>\\.[a-zA-Z0-9]+)?");

    @Inject
    public RegisterTableProcedure(IcebergMetadataFactory metadataFactory, HdfsEnvironment hdfsEnvironment) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public Procedure get() {
        return new Procedure("system", "register_table", (List)ImmutableList.of((Object)new Procedure.Argument("schema", "varchar"), (Object)new Procedure.Argument("table", "varchar"), (Object)new Procedure.Argument("metadataLocation", "varchar"), (Object)new Procedure.Argument("metadataFile", "varchar", false, null)), REGISTER_TABLE.bindTo(this));
    }

    public void registerTable(ConnectorSession clientSession, String schema, String table, String metadataLocation, String metadataFile) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doRegisterTable(clientSession, schema, table, metadataLocation, Optional.ofNullable(metadataFile));
        }
    }

    private void doRegisterTable(ConnectorSession clientSession, String schema, String table, String metadataLocation, Optional<String> metadataFile) {
        SchemaTableName schemaTableName;
        IcebergAbstractMetadata metadata = (IcebergAbstractMetadata)this.metadataFactory.create();
        if (!metadata.schemaExists(clientSession, (schemaTableName = new SchemaTableName(schema, table)).getSchemaName())) {
            throw new SchemaNotFoundException(schemaTableName.getSchemaName());
        }
        Path metadataDirectory = (metadataLocation = LocationUtil.stripTrailingSlash((String)metadataLocation)).endsWith(METADATA_FOLDER_NAME) ? new Path(metadataLocation) : new Path(metadataLocation, METADATA_FOLDER_NAME);
        Path metadataPath = metadataFile.map(metadataFileName -> new Path(metadataDirectory, metadataFileName)).orElseGet(() -> RegisterTableProcedure.resolveLatestMetadataLocation(clientSession, RegisterTableProcedure.getFileSystem(clientSession, this.hdfsEnvironment, schemaTableName, metadataDirectory), metadataDirectory));
        metadata.registerTable(clientSession, schemaTableName, metadataPath);
    }

    public static FileSystem getFileSystem(ConnectorSession clientSession, HdfsEnvironment hdfsEnvironment, SchemaTableName schemaTableName, Path location) {
        HdfsContext hdfsContext = new HdfsContext(clientSession, schemaTableName.getSchemaName(), schemaTableName.getTableName(), location.getName(), true);
        try {
            return hdfsEnvironment.getFileSystem(hdfsContext, location);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Error getting file system at path %s", location), (Throwable)e);
        }
    }

    public static Path resolveLatestMetadataLocation(ConnectorSession clientSession, FileSystem fileSystem, Path metadataPath) {
        int maxVersion = -1;
        long lastModifiedTime = -1L;
        Path metadataFile = null;
        boolean duplicateVersions = false;
        try {
            FileStatus[] files;
            for (FileStatus file : files = fileSystem.listStatus(metadataPath, name -> name.getName().contains(METADATA_FILE_EXTENSION))) {
                int version = RegisterTableProcedure.parseMetadataVersionFromFileName(file.getPath().getName());
                if (version > maxVersion) {
                    maxVersion = version;
                    metadataFile = file.getPath();
                    lastModifiedTime = file.getModificationTime();
                    duplicateVersions = false;
                    continue;
                }
                if (version != maxVersion) continue;
                duplicateVersions = true;
                long modifiedTime = file.getModificationTime();
                if (modifiedTime <= lastModifiedTime) continue;
                lastModifiedTime = modifiedTime;
                metadataFile = file.getPath();
            }
        }
        catch (IOException io) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Unable to find metadata at location %s", metadataPath), (Throwable)io);
        }
        if (duplicateVersions) {
            clientSession.getWarningCollector().add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.MULTIPLE_TABLE_METADATA, String.format("Multiple metadata files of most recent version %d found at location %s. Using most recently modified version", maxVersion, metadataPath)));
        }
        if (metadataFile == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("No metadata found at location %s", metadataPath));
        }
        return metadataFile;
    }

    static int parseMetadataVersionFromFileName(String fileName) {
        Matcher matcher = METADATA_VERSION_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("version"));
        }
        matcher = HADOOP_METADATA_VERSION_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("version"));
        }
        return -1;
    }
}

