/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.iceberg.Table;

public class SetTablePropertyProcedure
implements Provider<Procedure> {
    private static final Logger LOG = Logger.get(SetTablePropertyProcedure.class);
    private static final MethodHandle SET_TABLE_PROPERTY = MethodHandleUtil.methodHandle(SetTablePropertyProcedure.class, (String)"setTableProperty", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, String.class, String.class});
    private final IcebergConfig config;
    private final IcebergMetadataFactory metadataFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final IcebergResourceFactory resourceFactory;

    @Inject
    public SetTablePropertyProcedure(IcebergConfig config, IcebergMetadataFactory metadataFactory, HdfsEnvironment hdfsEnvironment, IcebergResourceFactory resourceFactory) {
        this.config = Objects.requireNonNull(config);
        this.metadataFactory = Objects.requireNonNull(metadataFactory);
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment);
        this.resourceFactory = Objects.requireNonNull(resourceFactory);
    }

    public Procedure get() {
        return new Procedure("system", "set_table_property", (List)ImmutableList.of((Object)new Procedure.Argument("schema", "varchar"), (Object)new Procedure.Argument("table", "varchar"), (Object)new Procedure.Argument("key", "varchar"), (Object)new Procedure.Argument("value", "varchar")), SET_TABLE_PROPERTY.bindTo(this));
    }

    public void setTableProperty(ConnectorSession session, String schema, String table, String key, String value) {
        ConnectorMetadata metadata = this.metadataFactory.create();
        IcebergTableName tableName = IcebergTableName.from(table);
        SchemaTableName schemaTableName = new SchemaTableName(schema, tableName.getTableName());
        Table icebergTable = IcebergUtil.getIcebergTable(metadata, session, schemaTableName);
        icebergTable.updateProperties().set(key, value).commit();
    }
}

