/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.util.PageListBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;

public class SnapshotsTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private static final String COMMITTED_AT_COLUMN_NAME = "committed_at";
    private static final String SNAPSHOT_ID_COLUMN_NAME = "snapshot_id";
    private static final String PARENT_ID_COLUMN_NAME = "parent_id";
    private static final String OPERATION_COLUMN_NAME = "operation";
    private static final String MANIFEST_LIST_COLUMN_NAME = "manifest_list";
    private static final String SUMMARY_COLUMN_NAME = "summary";

    public SnapshotsTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata(COMMITTED_AT_COLUMN_NAME, (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)).add((Object)new ColumnMetadata(SNAPSHOT_ID_COLUMN_NAME, (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata(PARENT_ID_COLUMN_NAME, (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata(OPERATION_COLUMN_NAME, (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata(MANIFEST_LIST_COLUMN_NAME, (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata(SUMMARY_COLUMN_NAME, typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)VarcharType.VARCHAR.getTypeSignature()))))).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(SnapshotsTable.buildPages(this.tableMetadata, session, this.icebergTable));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, ConnectorSession session, Table icebergTable) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        TableScan tableScan = IcebergUtil.buildTableScan(icebergTable, MetadataTableType.SNAPSHOTS);
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        Map<String, Integer> columnNameToPosition = IcebergUtil.columnNameToPositionInSchema(tableScan.schema());
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(fileScanTask -> SnapshotsTable.addRows((DataTask)fileScanTask, pagesBuilder, timeZoneKey, columnNameToPosition));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return pagesBuilder.build();
    }

    private static boolean checkNonNull(Object object, PageListBuilder pagesBuilder) {
        if (object == null) {
            pagesBuilder.appendNull();
            return false;
        }
        return true;
    }

    private static void addRows(DataTask dataTask, PageListBuilder pagesBuilder, TimeZoneKey timeZoneKey, Map<String, Integer> columnNameToPositionInSchema) {
        try (CloseableIterable dataRows = dataTask.rows();){
            dataRows.forEach(dataTaskRow -> SnapshotsTable.addRow(pagesBuilder, dataTaskRow, timeZoneKey, columnNameToPositionInSchema));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void addRow(PageListBuilder pagesBuilder, StructLike structLike, TimeZoneKey timeZoneKey, Map<String, Integer> columnNameToPositionInSchema) {
        Map summary;
        String manifestList;
        String operation;
        pagesBuilder.beginRow();
        pagesBuilder.appendTimestampTzMillis((Long)structLike.get(columnNameToPositionInSchema.get(COMMITTED_AT_COLUMN_NAME).intValue(), Long.class) / 1000L, timeZoneKey);
        pagesBuilder.appendBigint((Long)structLike.get(columnNameToPositionInSchema.get(SNAPSHOT_ID_COLUMN_NAME).intValue(), Long.class));
        Long parentId = (Long)structLike.get(columnNameToPositionInSchema.get(PARENT_ID_COLUMN_NAME).intValue(), Long.class);
        if (SnapshotsTable.checkNonNull(parentId, pagesBuilder)) {
            pagesBuilder.appendBigint(parentId);
        }
        if (SnapshotsTable.checkNonNull(operation = (String)structLike.get(columnNameToPositionInSchema.get(OPERATION_COLUMN_NAME).intValue(), String.class), pagesBuilder)) {
            pagesBuilder.appendVarchar(operation);
        }
        if (SnapshotsTable.checkNonNull(manifestList = (String)structLike.get(columnNameToPositionInSchema.get(MANIFEST_LIST_COLUMN_NAME).intValue(), String.class), pagesBuilder)) {
            pagesBuilder.appendVarchar(manifestList);
        }
        if (SnapshotsTable.checkNonNull(summary = (Map)structLike.get(columnNameToPositionInSchema.get(SUMMARY_COLUMN_NAME).intValue(), Map.class), pagesBuilder)) {
            pagesBuilder.appendVarcharVarcharMap(summary);
        }
        pagesBuilder.endRow();
    }
}

