/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class TypeConverter {
    public static final String ORC_ICEBERG_ID_KEY = "iceberg.id";
    public static final String ORC_ICEBERG_REQUIRED_KEY = "iceberg.required";

    private TypeConverter() {
    }

    public static com.facebook.presto.common.type.Type toPrestoType(Type type, TypeManager typeManager) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BINARY: 
            case FIXED: {
                return VarbinaryType.VARBINARY;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return DecimalType.createDecimalType((int)decimalType.precision(), (int)decimalType.scale());
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case TIME: {
                return TimeType.TIME;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case LIST: {
                Types.ListType listType = (Types.ListType)type;
                return new ArrayType(TypeConverter.toPrestoType(listType.elementType(), typeManager));
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)type;
                TypeSignature keyType = TypeConverter.toPrestoType(mapType.keyType(), typeManager).getTypeSignature();
                TypeSignature valueType = TypeConverter.toPrestoType(mapType.valueType(), typeManager).getTypeSignature();
                return typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType), (Object)TypeSignatureParameter.of((TypeSignature)valueType)));
            }
            case STRUCT: {
                List fields = ((Types.StructType)type).fields();
                return RowType.from((List)((List)fields.stream().map(field -> new RowType.Field(Optional.of(field.name()), TypeConverter.toPrestoType(field.type(), typeManager))).collect(ImmutableList.toImmutableList())));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert from Iceberg type '%s' (%s) to Presto type", type, type.typeId()));
    }

    public static Type toIcebergType(com.facebook.presto.common.type.Type type) {
        if (type instanceof BooleanType) {
            return Types.BooleanType.get();
        }
        if (type instanceof IntegerType) {
            return Types.IntegerType.get();
        }
        if (type instanceof BigintType) {
            return Types.LongType.get();
        }
        if (type instanceof RealType) {
            return Types.FloatType.get();
        }
        if (type instanceof DoubleType) {
            return Types.DoubleType.get();
        }
        if (type instanceof DecimalType) {
            return TypeConverter.fromDecimal((DecimalType)type);
        }
        if (type instanceof VarcharType) {
            return Types.StringType.get();
        }
        if (type instanceof VarbinaryType) {
            return Types.BinaryType.get();
        }
        if (type instanceof DateType) {
            return Types.DateType.get();
        }
        if (type instanceof RowType) {
            return TypeConverter.fromRow((RowType)type);
        }
        if (type instanceof ArrayType) {
            return TypeConverter.fromArray((ArrayType)type);
        }
        if (type instanceof MapType) {
            return TypeConverter.fromMap((MapType)type);
        }
        if (type instanceof TimeType) {
            return Types.TimeType.get();
        }
        if (type instanceof TimestampType) {
            return Types.TimestampType.withoutZone();
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return Types.TimestampType.withZone();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type not supported for Iceberg: " + type.getDisplayName());
    }

    public static HiveType toHiveType(com.facebook.presto.common.type.Type type) {
        return HiveType.toHiveType((TypeInfo)TypeConverter.toHiveTypeInfo(type));
    }

    private static Type fromDecimal(DecimalType type) {
        return Types.DecimalType.of((int)type.getPrecision(), (int)type.getScale());
    }

    public static Type fromRow(RowType type, int startId) {
        ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>();
        for (RowType.Field field : type.getFields()) {
            String name = (String)field.getName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Row type field does not have a name: " + type.getDisplayName()));
            fields.add(Types.NestedField.optional((int)(startId + fields.size() + 1), (String)name, (Type)TypeConverter.toIcebergType(field.getType())));
        }
        return Types.StructType.of(fields);
    }

    public static Type fromRow(RowType type) {
        return TypeConverter.fromRow(type, 0);
    }

    private static Type fromArray(ArrayType type) {
        return Types.ListType.ofOptional((int)1, (Type)TypeConverter.toIcebergType(type.getElementType()));
    }

    private static Type fromMap(MapType type) {
        return Types.MapType.ofOptional((int)1, (int)2, (Type)TypeConverter.toIcebergType(type.getKeyType()), (Type)TypeConverter.toIcebergType(type.getValueType()));
    }

    private static TypeInfo toHiveTypeInfo(com.facebook.presto.common.type.Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HiveType.HIVE_BOOLEAN.getTypeInfo();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HiveType.HIVE_LONG.getTypeInfo();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return HiveType.HIVE_INT.getTypeInfo();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return HiveType.HIVE_SHORT.getTypeInfo();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return HiveType.HIVE_BYTE.getTypeInfo();
        }
        if (RealType.REAL.equals((Object)type)) {
            return HiveType.HIVE_FLOAT.getTypeInfo();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HiveType.HIVE_DOUBLE.getTypeInfo();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return HiveType.HIVE_STRING.getTypeInfo();
            }
            if (varcharType.getLengthSafe() <= 65535) {
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharType.getLengthSafe());
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported VARCHAR types: VARCHAR(<=%d), VARCHAR.", type, 65535));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            if (charLength <= 255) {
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported CHAR types: CHAR(<=%d).", type, 255));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HiveType.HIVE_BINARY.getTypeInfo();
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveType.HIVE_DATE.getTypeInfo();
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
        }
        if (MetastoreUtil.isArrayType((com.facebook.presto.common.type.Type)type)) {
            TypeInfo elementType = TypeConverter.toHiveTypeInfo((com.facebook.presto.common.type.Type)type.getTypeParameters().get(0));
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (MetastoreUtil.isMapType((com.facebook.presto.common.type.Type)type)) {
            TypeInfo keyType = TypeConverter.toHiveTypeInfo((com.facebook.presto.common.type.Type)type.getTypeParameters().get(0));
            TypeInfo valueType = TypeConverter.toHiveTypeInfo((com.facebook.presto.common.type.Type)type.getTypeParameters().get(1));
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (MetastoreUtil.isRowType((com.facebook.presto.common.type.Type)type)) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                if (!namedTypeSignature.getName().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Anonymous row type is not supported in Hive. Please give each field a name: %s", type));
                }
                fieldNames.add(namedTypeSignature.getName().get());
            }
            return TypeInfoFactory.getStructTypeInfo((List)fieldNames.build(), type.getTypeParameters().stream().map(TypeConverter::toHiveTypeInfo).collect(Collectors.toList()));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }

    public static List<OrcType> toOrcType(Schema schema) {
        return TypeConverter.toOrcStructType(0, schema.asStruct(), (Map<String, String>)ImmutableMap.of());
    }

    private static List<OrcType> toOrcType(int nextFieldTypeIndex, Type type, Map<String, String> attributes) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BOOLEAN, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case INTEGER: 
            case TIME: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case LONG: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.LONG, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case FLOAT: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.FLOAT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case DOUBLE: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DOUBLE, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case DATE: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DATE, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case TIMESTAMP: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.TIMESTAMP, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case STRING: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.STRING, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case BINARY: 
            case FIXED: 
            case UUID: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BINARY, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DECIMAL, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.of(decimalType.precision()), Optional.of(decimalType.scale()), attributes));
            }
            case STRUCT: {
                return TypeConverter.toOrcStructType(nextFieldTypeIndex, (Types.StructType)type, attributes);
            }
            case LIST: {
                return TypeConverter.toOrcListType(nextFieldTypeIndex, (Types.ListType)type, attributes);
            }
            case MAP: {
                return TypeConverter.toOrcMapType(nextFieldTypeIndex, (Types.MapType)type, attributes);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Iceberg type: " + type);
    }

    private static List<OrcType> toOrcStructType(int nextFieldTypeIndex, Types.StructType structType, Map<String, String> attributes) {
        ++nextFieldTypeIndex;
        ArrayList<Integer> fieldTypeIndexes = new ArrayList<Integer>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<List<OrcType>> fieldTypesList = new ArrayList<List<OrcType>>();
        for (Types.NestedField field : structType.fields()) {
            fieldTypeIndexes.add(nextFieldTypeIndex);
            fieldNames.add(field.name());
            ImmutableMap fieldAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(field.fieldId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(field.isRequired())).build();
            List<OrcType> fieldOrcTypes = TypeConverter.toOrcType(nextFieldTypeIndex, field.type(), (Map<String, String>)fieldAttributes);
            fieldTypesList.add(fieldOrcTypes);
            nextFieldTypeIndex += fieldOrcTypes.size();
        }
        ImmutableList.Builder orcTypes = ImmutableList.builder();
        orcTypes.add((Object)new OrcType(OrcType.OrcTypeKind.STRUCT, fieldTypeIndexes, fieldNames, Optional.empty(), Optional.empty(), Optional.empty(), attributes));
        fieldTypesList.forEach(arg_0 -> ((ImmutableList.Builder)orcTypes).addAll(arg_0));
        return orcTypes.build();
    }

    private static List<OrcType> toOrcListType(int nextFieldTypeIndex, Types.ListType listType, Map<String, String> attributes) {
        ImmutableMap elementAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(listType.elementId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(listType.isElementRequired())).build();
        List<OrcType> itemTypes = TypeConverter.toOrcType(++nextFieldTypeIndex, listType.elementType(), (Map<String, String>)elementAttributes);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcType.OrcTypeKind.LIST, (List)ImmutableList.of((Object)nextFieldTypeIndex), (List)ImmutableList.of((Object)"item"), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
        orcTypes.addAll(itemTypes);
        return orcTypes;
    }

    private static List<OrcType> toOrcMapType(int nextFieldTypeIndex, Types.MapType mapType, Map<String, String> attributes) {
        ImmutableMap keyAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(mapType.keyId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(true)).build();
        List<OrcType> keyTypes = TypeConverter.toOrcType(++nextFieldTypeIndex, mapType.keyType(), (Map<String, String>)keyAttributes);
        ImmutableMap valueAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(mapType.valueId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(mapType.isValueRequired())).build();
        List<OrcType> valueTypes = TypeConverter.toOrcType(nextFieldTypeIndex + keyTypes.size(), mapType.valueType(), (Map<String, String>)valueAttributes);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcType.OrcTypeKind.MAP, (List)ImmutableList.of((Object)nextFieldTypeIndex, (Object)(nextFieldTypeIndex + keyTypes.size())), (List)ImmutableList.of((Object)"key", (Object)"value"), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
        orcTypes.addAll(keyTypes);
        orcTypes.addAll(valueTypes);
        return orcTypes;
    }
}

