/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class UnregisterTableProcedure
implements Provider<Procedure> {
    private static final MethodHandle UNREGISTER_TABLE = MethodHandleUtil.methodHandle(UnregisterTableProcedure.class, (String)"unregisterTable", (Class[])new Class[]{ConnectorSession.class, String.class, String.class});
    private final IcebergMetadataFactory metadataFactory;

    @Inject
    public UnregisterTableProcedure(IcebergMetadataFactory metadataFactory) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
    }

    public Procedure get() {
        return new Procedure("system", "unregister_table", (List)ImmutableList.of((Object)new Procedure.Argument("schema", "varchar"), (Object)new Procedure.Argument("table", "varchar")), UNREGISTER_TABLE.bindTo(this));
    }

    public void unregisterTable(ConnectorSession clientSession, String schema, String table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doUnregisterTable(clientSession, schema, table);
        }
    }

    private void doUnregisterTable(ConnectorSession clientSession, String schema, String table) {
        SchemaTableName schemaTableName;
        IcebergAbstractMetadata metadata = (IcebergAbstractMetadata)this.metadataFactory.create();
        if (!metadata.schemaExists(clientSession, (schemaTableName = new SchemaTableName(schema, table)).getSchemaName())) {
            throw new SchemaNotFoundException(schemaTableName.getSchemaName());
        }
        metadata.unregisterTable(clientSession, schemaTableName);
    }
}

