/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.changelog;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public enum ChangelogOperation {
    INSERT,
    DELETE,
    UPDATE_BEFORE,
    UPDATE_AFTER;


    public static ChangelogOperation fromIcebergChangelogOperation(org.apache.iceberg.ChangelogOperation operation) {
        ChangelogOperation prestoOperation;
        switch (operation) {
            case INSERT: {
                prestoOperation = INSERT;
                break;
            }
            case DELETE: {
                prestoOperation = DELETE;
                break;
            }
            case UPDATE_BEFORE: {
                prestoOperation = UPDATE_BEFORE;
                break;
            }
            case UPDATE_AFTER: {
                prestoOperation = UPDATE_AFTER;
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Changelog Operation: " + operation);
            }
        }
        return prestoOperation;
    }
}

