/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.changelog;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.changelog.ChangelogSplitInfo;
import com.facebook.presto.iceberg.changelog.ChangelogUtil;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChangelogPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final ChangelogSplitInfo changelogSplitInfo;
    private final List<IcebergColumnHandle> desiredColumns;
    private final RowType innerRowType;

    public ChangelogPageSource(ConnectorPageSource delegate, ChangelogSplitInfo changelogSplitInfo, List<IcebergColumnHandle> desiredColumns, List<IcebergColumnHandle> delegateColumns) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.changelogSplitInfo = Objects.requireNonNull(changelogSplitInfo, "changelogSplitInfo is null");
        this.desiredColumns = Objects.requireNonNull(desiredColumns, "columns is null");
        this.innerRowType = RowType.from(delegateColumns.stream().map(x -> new RowType.Field(Optional.of(x.getName()), x.getType())).collect(Collectors.toList()));
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        Page delegatePage = this.delegate.getNextPage();
        if (delegatePage == null) {
            return null;
        }
        Block[] columns = new Block[this.desiredColumns.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = ChangelogSchemaColumns.valueOf(this.desiredColumns.get(i).getName().toUpperCase()).getBlock(this, delegatePage);
        }
        return new Page(delegatePage.getPositionCount(), columns);
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public static enum ChangelogSchemaColumns {
        OPERATION((source, page) -> RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)((ChangelogPageSource)source).changelogSplitInfo.getOperation().toString()), (int)page.getPositionCount())),
        ORDINAL((source, page) -> RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)((ChangelogPageSource)source).changelogSplitInfo.getOrdinal(), (int)page.getPositionCount())),
        SNAPSHOTID((source, page) -> RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)((ChangelogPageSource)source).changelogSplitInfo.getSnapshotId(), (int)page.getPositionCount())),
        ROWDATA((source, page) -> {
            if (((ChangelogPageSource)source).innerRowType.getFields().size() != page.getChannelCount()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CORRUPT_PAGE, "delegate page channels do not match expected number of channels");
            }
            Block[] channels = new Block[page.getChannelCount()];
            for (int i = 0; i < page.getChannelCount(); ++i) {
                channels[i] = page.getBlock(i);
            }
            return RowBlock.fromFieldBlocks((int)page.getPositionCount(), Optional.empty(), (Block[])channels);
        });

        private final ChangelogUtil.Function2<ChangelogPageSource, Page, Block> blockSupplier;

        private ChangelogSchemaColumns(ChangelogUtil.Function2<ChangelogPageSource, Page, Block> blockSupplier) {
            this.blockSupplier = blockSupplier;
        }

        public Block getBlock(ChangelogPageSource pageSource, Page page) {
            return this.blockSupplier.apply(pageSource, page);
        }
    }
}

