/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.changelog;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergSplit;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.changelog.ChangelogOperation;
import com.facebook.presto.iceberg.changelog.ChangelogSplitInfo;
import com.facebook.presto.iceberg.delete.DeleteFile;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.AddedRowsScanTask;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeletedDataFileScanTask;
import org.apache.iceberg.DeletedRowsScanTask;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterator;

public class ChangelogSplitSource
implements ConnectorSplitSource {
    private CloseableIterator<ChangelogScanTask> fileScanTaskIterator;
    private final IncrementalChangelogScan tableScan;
    private final double minimumAssignedSplitWeight;
    private final ConnectorSession session;
    private final List<IcebergColumnHandle> columnHandles;

    public ChangelogSplitSource(ConnectorSession session, TypeManager typeManager, Table table, IncrementalChangelogScan tableScan, double minimumAssignedSplitWeight) {
        this.session = Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.columnHandles = IcebergUtil.getColumns(table.schema(), table.spec(), typeManager);
        this.tableScan = Objects.requireNonNull(tableScan, "tableScan is null");
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        this.fileScanTaskIterator = tableScan.planFiles().iterator();
    }

    public boolean isFinished() {
        return !this.fileScanTaskIterator.hasNext();
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>();
        Iterator iterator = Iterators.limit(this.fileScanTaskIterator, (int)maxSize);
        while (iterator.hasNext()) {
            ChangelogScanTask task = (ChangelogScanTask)iterator.next();
            splits.add(this.toIcebergSplit(task));
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
    }

    public void close() {
        try {
            this.fileScanTaskIterator.close();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private ConnectorSplit toIcebergSplit(ChangelogScanTask task) {
        if (task instanceof AddedRowsScanTask || task instanceof DeletedRowsScanTask || task instanceof DeletedDataFileScanTask) {
            ContentScanTask scanTask = (ContentScanTask)task;
            return this.splitFromContentScanTask((ContentScanTask<DataFile>)scanTask, task);
        }
        throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, "unsupported task type " + task.getClass().getCanonicalName());
    }

    private IcebergSplit splitFromContentScanTask(ContentScanTask<DataFile> task, ChangelogScanTask changeTask) {
        return new IcebergSplit(((DataFile)task.file()).path().toString(), task.start(), task.length(), FileFormat.fromIcebergFileFormat(((DataFile)task.file()).format()), (List<HostAddress>)ImmutableList.of(), IcebergUtil.getPartitionKeys(task), HiveCommonSessionProperties.getNodeSelectionStrategy((ConnectorSession)this.session), SplitWeight.fromProportion((double)Math.min(Math.max((double)task.length() / (double)this.tableScan.targetSplitSize(), this.minimumAssignedSplitWeight), 1.0)), (List<DeleteFile>)ImmutableList.of(), Optional.of(new ChangelogSplitInfo(ChangelogOperation.fromIcebergChangelogOperation(changeTask.operation()), changeTask.changeOrdinal(), changeTask.commitSnapshotId(), this.columnHandles)), IcebergUtil.getDataSequenceNumber(task.file()));
    }
}

