/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.changelog;

import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class ChangelogUtil {
    private ChangelogUtil() {
    }

    public static Schema changelogTableSchema(RowType rowType) {
        return new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"operation", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"ordinal", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"snapshotid", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"rowdata", (Type)TypeConverter.fromRow(rowType, 4))});
    }

    public static ConnectorTableMetadata getChangelogTableMeta(SchemaTableName tableName, TypeManager typeManager, List<ColumnMetadata> columns) {
        return new ConnectorTableMetadata(tableName, ChangelogUtil.getColumnMetadata(typeManager, columns));
    }

    public static RowType getRowTypeFromColumnMeta(List<ColumnMetadata> columns) {
        return RowType.from((List)((List)columns.stream().map(column -> RowType.field((String)column.getName(), (com.facebook.presto.common.type.Type)column.getType())).collect(ImmutableList.toImmutableList())));
    }

    public static List<ColumnMetadata> getColumnMetadata(TypeManager typeManager, List<ColumnMetadata> columns) {
        return (List)ChangelogUtil.changelogTableSchema(ChangelogUtil.getRowTypeFromColumnMeta(columns)).columns().stream().map(column -> new ColumnMetadata(column.name(), TypeConverter.toPrestoType(column.type(), typeManager))).collect(ImmutableList.toImmutableList());
    }

    @FunctionalInterface
    protected static interface Function2<T1, T2, R> {
        public R apply(T1 var1, T2 var2);
    }
}

