/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.delete;

import com.facebook.presto.iceberg.FileContent;
import com.facebook.presto.iceberg.FileFormat;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DeleteFile {
    private final FileContent content;
    private final String path;
    private final FileFormat format;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final List<Integer> equalityFieldIds;
    private final Map<Integer, byte[]> lowerBounds;
    private final Map<Integer, byte[]> upperBounds;

    public static DeleteFile fromIceberg(org.apache.iceberg.DeleteFile deleteFile) {
        Map lowerBounds = (Map)((Map)MoreObjects.firstNonNull((Object)deleteFile.lowerBounds(), (Object)ImmutableMap.of())).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (byte[])((ByteBuffer)entry.getValue()).array().clone()));
        Map upperBounds = (Map)((Map)MoreObjects.firstNonNull((Object)deleteFile.upperBounds(), (Object)ImmutableMap.of())).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (byte[])((ByteBuffer)entry.getValue()).array().clone()));
        return new DeleteFile(FileContent.fromIcebergFileContent(deleteFile.content()), deleteFile.path().toString(), FileFormat.fromIcebergFileFormat(deleteFile.format()), deleteFile.recordCount(), deleteFile.fileSizeInBytes(), Optional.ofNullable(deleteFile.equalityFieldIds()).orElseGet(ImmutableList::of), lowerBounds, upperBounds);
    }

    @JsonCreator
    public DeleteFile(@JsonProperty(value="content") FileContent content, @JsonProperty(value="path") String path, @JsonProperty(value="format") FileFormat format, @JsonProperty(value="recordCount") long recordCount, @JsonProperty(value="fileSizeInBytes") long fileSizeInBytes, @JsonProperty(value="equalityFieldIds") List<Integer> equalityFieldIds, @JsonProperty(value="lowerBounds") Map<Integer, byte[]> lowerBounds, @JsonProperty(value="upperBounds") Map<Integer, byte[]> upperBounds) {
        this.content = Objects.requireNonNull(content, "content is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.format = Objects.requireNonNull(format, "format is null");
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.equalityFieldIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(equalityFieldIds, "equalityFieldIds is null"));
        this.lowerBounds = ImmutableMap.copyOf(Objects.requireNonNull(lowerBounds, "lowerBounds is null"));
        this.upperBounds = ImmutableMap.copyOf(Objects.requireNonNull(upperBounds, "upperBounds is null"));
    }

    @JsonProperty
    public FileContent content() {
        return this.content;
    }

    @JsonProperty
    public String path() {
        return this.path;
    }

    @JsonProperty
    public FileFormat format() {
        return this.format;
    }

    @JsonProperty
    public long recordCount() {
        return this.recordCount;
    }

    @JsonProperty
    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    @JsonProperty
    public List<Integer> equalityFieldIds() {
        return this.equalityFieldIds;
    }

    @JsonProperty
    public Map<Integer, byte[]> getLowerBounds() {
        return this.lowerBounds;
    }

    @JsonProperty
    public Map<Integer, byte[]> getUpperBounds() {
        return this.upperBounds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).add("records", this.recordCount).toString();
    }
}

