/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.delete;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.delete.DeleteFilter;
import com.facebook.presto.iceberg.delete.RowPredicate;
import com.facebook.presto.spi.ConnectorPageSource;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Objects;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;

public final class PositionDeleteFilter
implements DeleteFilter {
    private final ImmutableLongBitmapDataProvider deletedRows;

    public PositionDeleteFilter(ImmutableLongBitmapDataProvider deletedRows) {
        this.deletedRows = Objects.requireNonNull(deletedRows, "deletedRows is null");
    }

    @Override
    public RowPredicate createPredicate(List<IcebergColumnHandle> columns) {
        int filePosChannel = PositionDeleteFilter.rowPositionChannel(columns);
        return (page, position) -> {
            long filePos = BigintType.BIGINT.getLong(page.getBlock(filePosChannel), position);
            return !this.deletedRows.contains(filePos);
        };
    }

    private static int rowPositionChannel(List<IcebergColumnHandle> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).isRowPositionColumn()) continue;
            return i;
        }
        throw new IllegalArgumentException("No row position column");
    }

    public static void readPositionDeletes(ConnectorPageSource pageSource, Slice targetPath, LongBitmapDataProvider deletedRows) {
        CachingVarcharComparator comparator = new CachingVarcharComparator(targetPath);
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            Block pathBlock = page.getBlock(0);
            Block posBlock = page.getBlock(1);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int result = comparator.compare(pathBlock, position);
                if (result > 0) {
                    return;
                }
                if (result != 0) continue;
                deletedRows.addLong(BigintType.BIGINT.getLong(posBlock, position));
            }
        }
    }

    private static final class CachingVarcharComparator {
        private final Slice reference;
        private int result;
        private Slice value;

        public CachingVarcharComparator(Slice reference) {
            this.reference = Objects.requireNonNull(reference, "reference is null");
        }

        public int compare(Block block, int position) {
            Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
            Slice next = VarcharType.VARCHAR.getSlice(block, position);
            if (this.value != next) {
                this.value = next;
                this.result = this.value.compareTo(this.reference);
            }
            return this.result;
        }
    }
}

