/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.delete;

import com.facebook.presto.common.Page;
import java.util.Objects;

public interface RowPredicate {
    public boolean test(Page var1, int var2);

    default public RowPredicate and(RowPredicate other) {
        Objects.requireNonNull(other, "other is null");
        return (page, position) -> this.test(page, position) && other.test(page, position);
    }

    default public Page filterPage(Page page) {
        int positionCount = page.getPositionCount();
        int[] retained = new int[positionCount];
        int retainedCount = 0;
        for (int position = 0; position < positionCount; ++position) {
            if (!this.test(page, position)) continue;
            retained[retainedCount] = position;
            ++retainedCount;
        }
        if (retainedCount == positionCount) {
            return page;
        }
        return page.getPositions(retained, 0, retainedCount);
    }
}

