/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.delete;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.iceberg.IcebergPageSink;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.iceberg.StructLike;

final class StructLikeRow
implements StructLike {
    private final Object[] values;

    public StructLikeRow(Type[] types, Page page, int position) {
        Preconditions.checkArgument((types.length == page.getChannelCount() ? 1 : 0) != 0, (Object)"mismatched types for page");
        this.values = new Object[types.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = IcebergPageSink.getIcebergValue(page.getBlock(i), position, types[i]);
        }
    }

    public int size() {
        return this.values.length;
    }

    public <T> T get(int i, Class<T> clazz) {
        return clazz.cast(this.values[i]);
    }

    public <T> void set(int i, T t) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "StructLikeRow" + Arrays.toString(this.values);
    }
}

