/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.equalitydeletes;

import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.iceberg.FileContent;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergSplit;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;

public class EqualityDeletesSplitSource
implements ConnectorSplitSource {
    private final ConnectorSession session;
    private final Map<Integer, PartitionSpec> specById;
    private CloseableIterator<DeleteFile> deleteFiles;

    public EqualityDeletesSplitSource(ConnectorSession session, Table table, CloseableIterable<DeleteFile> deleteFiles) {
        this.session = Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(deleteFiles, "deleteFiles is null");
        this.specById = table.specs();
        this.deleteFiles = CloseableIterable.filter(deleteFiles, deleteFile -> FileContent.fromIcebergFileContent(deleteFile.content()) == FileContent.EQUALITY_DELETES).iterator();
    }

    public boolean isFinished() {
        return !this.deleteFiles.hasNext();
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        ImmutableList.Builder splits = new ImmutableList.Builder();
        Iterator iterator = Iterators.limit(this.deleteFiles, (int)maxSize);
        iterator.forEachRemaining(manifestReader -> splits.add((Object)this.toIcebergSplit((DeleteFile)manifestReader)));
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch((List)splits.build(), this.isFinished()));
    }

    public void close() {
        try {
            this.deleteFiles.close();
            this.deleteFiles = CloseableIterator.empty();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    private ConnectorSplit toIcebergSplit(DeleteFile manifesReader) {
        return this.splitFromDeleteFile(manifesReader);
    }

    private IcebergSplit splitFromDeleteFile(DeleteFile deleteFile) {
        return new IcebergSplit(deleteFile.path().toString(), 0L, deleteFile.fileSizeInBytes(), FileFormat.fromIcebergFileFormat(deleteFile.format()), (List<HostAddress>)ImmutableList.of(), IcebergUtil.getPartitionKeys(this.specById.get(deleteFile.specId()), deleteFile.partition()), HiveCommonSessionProperties.getNodeSelectionStrategy((ConnectorSession)this.session), SplitWeight.standard(), (List<com.facebook.presto.iceberg.delete.DeleteFile>)ImmutableList.of(), Optional.empty(), IcebergUtil.getDataSequenceNumber(deleteFile));
    }
}

