/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.function.changelog;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.iceberg.changelog.ChangelogOperation;
import com.facebook.presto.iceberg.function.changelog.ApplyChangelogState;
import com.facebook.presto.iceberg.function.changelog.ChangelogRecord;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;
import java.util.Optional;

@AggregationFunction(value="apply_changelog", visibility=SqlFunctionVisibility.HIDDEN)
public class ApplyChangelogFunction {
    public static final String NAME = "apply_changelog";

    private ApplyChangelogFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState ApplyChangelogState state, @SqlType(value="bigint") long ordinal, @SqlType(value="varchar") Slice operation, @BlockPosition @SqlType(value="T") Block block, @BlockIndex int index) {
        ChangelogRecord record = state.getRecord().orElseGet(() -> new ChangelogRecord(type));
        record.add((int)ordinal, operation, block.getSingleValueBlock(index));
        state.setRecord(record);
    }

    @CombineFunction
    public static void combine(@AggregationState ApplyChangelogState state, @AggregationState ApplyChangelogState otherState) {
        if (!state.getRecord().isPresent() && !otherState.getRecord().isPresent()) {
            return;
        }
        ChangelogRecord record = !state.getRecord().isPresent() && otherState.getRecord().isPresent() ? otherState.getRecord().get() : (state.getRecord().isPresent() && !otherState.getRecord().isPresent() ? state.getRecord().get() : state.getRecord().get().merge(otherState.getRecord().get()));
        state.setRecord(record);
    }

    @OutputFunction(value="T")
    public static void output(@TypeParameter(value="T") Type elementType, @AggregationState ApplyChangelogState state, BlockBuilder out) {
        Optional<ChangelogRecord> record = state.getRecord();
        if (!record.isPresent()) {
            out.appendNull();
            return;
        }
        if (ChangelogOperation.valueOf(record.get().getLastOperation().toStringUtf8().toUpperCase()).equals((Object)ChangelogOperation.DELETE)) {
            out.appendNull();
        } else {
            elementType.appendTo(record.get().getRow(), 0, out);
        }
    }
}

