/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.function.changelog;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.iceberg.function.changelog.ApplyChangelogStateFactory;
import com.facebook.presto.iceberg.function.changelog.ApplyChangelogStateSerializer;
import com.facebook.presto.iceberg.function.changelog.ChangelogRecord;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateMetadata;
import com.facebook.presto.spi.function.GroupedAccumulatorState;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@AccumulatorStateMetadata(stateSerializerClass=ApplyChangelogStateSerializer.class, stateFactoryClass=ApplyChangelogStateFactory.class)
public interface ApplyChangelogState
extends AccumulatorState {
    public Type getType();

    public Optional<ChangelogRecord> getRecord();

    public void setRecord(@Nullable ChangelogRecord var1);

    public static class Grouped
    implements ApplyChangelogState,
    GroupedAccumulatorState {
        private final ObjectBigArray<ChangelogRecord> records = new ObjectBigArray();
        private long size;
        private final Type innerType;
        private long groupId;

        public Grouped(Type innerType) {
            this.innerType = innerType;
        }

        protected final long getGroupId() {
            return this.groupId;
        }

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public void ensureCapacity(long size) {
            this.records.ensureCapacity(size);
        }

        @Override
        public Type getType() {
            return this.innerType;
        }

        @Override
        public Optional<ChangelogRecord> getRecord() {
            return Optional.ofNullable(this.records.get(this.getGroupId()));
        }

        @Override
        public void setRecord(ChangelogRecord value) {
            Objects.requireNonNull(value, "value is null");
            this.size -= this.getRecord().map(ChangelogRecord::getEstimatedSize).orElse(0L).longValue();
            this.records.set(this.getGroupId(), (Object)value);
            this.size += value.getEstimatedSize();
        }

        public long getEstimatedSize() {
            return this.size + this.records.sizeOf();
        }
    }

    public static class Single
    implements ApplyChangelogState {
        private final Type innerType;
        private ChangelogRecord record;

        public Single(Type innerType) {
            this.innerType = innerType;
        }

        @Override
        public Type getType() {
            return this.innerType;
        }

        @Override
        public Optional<ChangelogRecord> getRecord() {
            return Optional.ofNullable(this.record);
        }

        @Override
        public void setRecord(ChangelogRecord value) {
            this.record = value;
        }

        public long getEstimatedSize() {
            if (this.record == null) {
                return 0L;
            }
            return this.record.getEstimatedSize();
        }
    }
}

