/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.function.changelog;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.function.changelog.ApplyChangelogState;
import com.facebook.presto.iceberg.function.changelog.ChangelogRecord;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.TypeParameter;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class ApplyChangelogStateSerializer
implements AccumulatorStateSerializer<ApplyChangelogState> {
    private final Type serializedType;

    public ApplyChangelogStateSerializer(@TypeParameter(value="T") Type innerType) {
        this.serializedType = ApplyChangelogStateSerializer.getSerializedRowType(innerType);
    }

    private static Type getSerializedRowType(Type inner) {
        return RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)inner));
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(ApplyChangelogState state, BlockBuilder out) {
        if (!state.getRecord().isPresent()) {
            out.appendNull();
        } else {
            state.getRecord().get().serialize(out);
        }
    }

    public void deserialize(Block block, int index, ApplyChangelogState state) {
        ChangelogRecord record = new ChangelogRecord(state.getType());
        record.deserialize(block, index);
        state.setRecord(record);
    }
}

