/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.function.changelog;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.SingleRowBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.changelog.ChangelogOperation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class ChangelogRecord {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ChangelogRecord.class).instanceSize();
    private Block lastRow;
    private Slice lastOperation;
    private int lastOrdinal;
    private final Type serializedType;
    private final Type stateType;

    private static Type getSerializedRowType(Type inner) {
        return RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)inner));
    }

    public ChangelogRecord(Type stateType) {
        this.stateType = Objects.requireNonNull(stateType, "type is null");
        this.serializedType = ChangelogRecord.getSerializedRowType(stateType);
        this.lastOperation = Slices.EMPTY_SLICE;
        this.lastOrdinal = -1;
    }

    public ChangelogRecord(Type stateType, int lastOrdinal, Slice lastOperation, Block lastRow) {
        this(stateType);
        this.lastOrdinal = lastOrdinal;
        this.lastOperation = lastOperation;
        this.lastRow = lastRow;
    }

    public void add(Integer ordinal, Slice operation, Block row) {
        this.merge(new ChangelogRecord(this.stateType, ordinal, operation, row));
    }

    public Block getRow() {
        return this.lastRow;
    }

    public Slice getLastOperation() {
        return this.lastOperation;
    }

    private int getLastOrdinal() {
        return this.lastOrdinal;
    }

    public ChangelogRecord merge(ChangelogRecord other) {
        if (other.lastOrdinal > this.lastOrdinal) {
            this.lastOperation = other.lastOperation;
            this.lastRow = other.lastRow;
            this.lastOrdinal = other.lastOrdinal;
        } else if (other.lastOrdinal == this.lastOrdinal) {
            ChangelogOperation operation = ChangelogOperation.valueOf(other.lastOperation.toStringUtf8().toUpperCase());
            switch (operation) {
                case UPDATE_AFTER: 
                case INSERT: {
                    if (ChangelogOperation.valueOf(this.lastOperation.toStringUtf8().toUpperCase()).equals((Object)ChangelogOperation.INSERT)) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "unresolvable order for two inserts");
                    }
                    this.lastOperation = other.lastOperation;
                    this.lastRow = other.lastRow;
                    this.lastOrdinal = other.lastOrdinal;
                    break;
                }
                case UPDATE_BEFORE: 
                case DELETE: {
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "unsupported operation type " + (Object)((Object)operation));
                }
            }
        }
        return this;
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder entry = out.beginBlockEntry();
        BigintType.BIGINT.writeLong(entry, (long)this.lastOrdinal);
        VarcharType.VARCHAR.writeSlice(entry, this.lastOperation);
        this.stateType.appendTo(this.lastRow, 0, entry);
        out.closeEntry();
    }

    public void deserialize(Block block, int index) {
        Block serializedStateBlock = block.getSingleValueBlock(index);
        if (!(serializedStateBlock instanceof RowBlock)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "changelog deserialization must only be row block type");
        }
        SingleRowBlock row = (SingleRowBlock)this.serializedType.getObject(serializedStateBlock, 0);
        this.lastOrdinal = (int)row.getLong(0);
        this.lastOperation = row.getSlice(1, 0, row.getSliceLength(1));
        this.lastRow = row.getSingleValueBlock(2);
    }

    public long getEstimatedSize() {
        long size = INSTANCE_SIZE + IntegerType.INTEGER.getFixedSize();
        if (this.lastOperation != null) {
            size += this.lastOperation.getRetainedSize();
        }
        if (this.lastRow != null) {
            size += this.lastRow.getSizeInBytes();
        }
        return size;
    }
}

