/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.nessie;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.iceberg.nessie.AuthenticationType;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;

public class NessieConfig {
    private String defaultReferenceName = "main";
    private String serverUri;
    private AuthenticationType authenticationType;
    private String username;
    private String password;
    private String bearerToken;
    private Integer readTimeoutMillis;
    private Integer connectTimeoutMillis;
    private String clientBuilderImpl;
    private boolean compressionEnabled = true;

    @NotEmpty(message="must not be null or empty")
    public @NotEmpty(message="must not be null or empty") String getDefaultReferenceName() {
        return this.defaultReferenceName;
    }

    @Config(value="iceberg.nessie.ref")
    @ConfigDescription(value="The default Nessie reference to work on")
    public NessieConfig setDefaultReferenceName(String defaultReferenceName) {
        this.defaultReferenceName = defaultReferenceName;
        return this;
    }

    public Optional<String> getServerUri() {
        return Optional.ofNullable(this.serverUri);
    }

    @Config(value="iceberg.nessie.uri")
    @ConfigDescription(value="The URI to connect to the Nessie server")
    public NessieConfig setServerUri(String serverUri) {
        this.serverUri = serverUri;
        return this;
    }

    @Config(value="iceberg.nessie.auth.type")
    @ConfigDescription(value="The authentication type to use. Available values are BASIC | BEARER")
    public NessieConfig setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Optional<AuthenticationType> getAuthenticationType() {
        return Optional.ofNullable(this.authenticationType);
    }

    @Config(value="iceberg.nessie.auth.basic.username")
    @ConfigDescription(value="The username to use with BASIC authentication")
    @Deprecated
    public NessieConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    @Deprecated
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Config(value="iceberg.nessie.auth.basic.password")
    @ConfigDescription(value="The password to use with BASIC authentication")
    @Deprecated
    public NessieConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Deprecated
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Config(value="iceberg.nessie.auth.bearer.token")
    @ConfigDescription(value="The token to use with BEARER authentication")
    public NessieConfig setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return this;
    }

    public Optional<String> getBearerToken() {
        return Optional.ofNullable(this.bearerToken);
    }

    @Config(value="iceberg.nessie.read-timeout-ms")
    @ConfigDescription(value="The read timeout in milliseconds for the client")
    public NessieConfig setReadTimeoutMillis(Integer readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public Optional<Integer> getReadTimeoutMillis() {
        return Optional.ofNullable(this.readTimeoutMillis);
    }

    @Config(value="iceberg.nessie.connect-timeout-ms")
    @ConfigDescription(value="The connection timeout in milliseconds for the client")
    public NessieConfig setConnectTimeoutMillis(Integer connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public Optional<Integer> getConnectTimeoutMillis() {
        return Optional.ofNullable(this.connectTimeoutMillis);
    }

    @Config(value="iceberg.nessie.compression-enabled")
    @ConfigDescription(value="Configure whether compression should be enabled or not. Default: true")
    public NessieConfig setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Config(value="iceberg.nessie.client-builder-impl")
    @ConfigDescription(value="Configure the custom ClientBuilder implementation class to be used")
    public NessieConfig setClientBuilderImpl(String clientBuilderImpl) {
        this.clientBuilderImpl = clientBuilderImpl;
        return this;
    }

    public Optional<String> getClientBuilderImpl() {
        return Optional.ofNullable(this.clientBuilderImpl);
    }
}

