/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.optimizer;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.iceberg.ColumnIdentity;
import com.facebook.presto.iceberg.FileContent;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergMetadataColumn;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.ConnectorJoinNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergEqualityDeleteAsJoin
implements ConnectorPlanOptimizer {
    private final StandardFunctionResolution functionResolution;
    private final IcebergTransactionManager transactionManager;
    private final TypeManager typeManager;

    IcebergEqualityDeleteAsJoin(StandardFunctionResolution functionResolution, IcebergTransactionManager transactionManager, TypeManager typeManager) {
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        if (!IcebergSessionProperties.isDeleteToJoinPushdownEnabled(session)) {
            return maxSubplan;
        }
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new DeleteAsJoinRewriter(this.functionResolution, this.transactionManager, idAllocator, session, this.typeManager, variableAllocator), (PlanNode)maxSubplan);
    }

    private static class DeleteAsJoinRewriter
    extends ConnectorPlanRewriter<Void> {
        private final ConnectorSession session;
        private final StandardFunctionResolution functionResolution;
        private final PlanNodeIdAllocator idAllocator;
        private final IcebergTransactionManager transactionManager;
        private final TypeManager typeManager;
        private final VariableAllocator variableAllocator;

        public DeleteAsJoinRewriter(StandardFunctionResolution functionResolution, IcebergTransactionManager transactionManager, PlanNodeIdAllocator idAllocator, ConnectorSession session, TypeManager typeManager, VariableAllocator variableAllocator) {
            this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        }

        public PlanNode visitTableScan(TableScanNode node, ConnectorPlanRewriter.RewriteContext<Void> context) {
            TableHandle table = node.getTable();
            IcebergTableHandle icebergTableHandle = (IcebergTableHandle)table.getConnectorHandle();
            IcebergTableName tableName = icebergTableHandle.getIcebergTableName();
            if (!tableName.getSnapshotId().isPresent() || tableName.getTableType() != IcebergTableType.DATA) {
                return node;
            }
            IcebergAbstractMetadata metadata = (IcebergAbstractMetadata)this.transactionManager.get(table.getTransaction());
            Table icebergTable = IcebergUtil.getIcebergTable(metadata, this.session, icebergTableHandle.getSchemaTableName());
            ImmutableMap<Set<Integer>, DeleteSetInfo> deleteSchemas = DeleteAsJoinRewriter.collectDeleteInformation(icebergTable, icebergTableHandle, tableName.getSnapshotId().get());
            if (deleteSchemas.isEmpty()) {
                return node;
            }
            ImmutableMap<VariableReferenceExpression, ColumnHandle> unselectedAssignments = this.createAssignmentsForUnselectedFields(node, deleteSchemas, icebergTable);
            TableScanNode updatedTableScan = this.createNewRoot(node, icebergTableHandle, tableName, unselectedAssignments, table);
            Map<Integer, VariableReferenceExpression> reverseAssignmentsMap = updatedTableScan.getAssignments().entrySet().stream().collect(Collectors.toMap(assignment -> ((IcebergColumnHandle)((Object)((Object)assignment.getValue()))).getId(), Map.Entry::getKey));
            ArrayList<VariableReferenceExpression> deleteVersionColumns = new ArrayList<VariableReferenceExpression>();
            TableScanNode parentNode = updatedTableScan;
            for (Map.Entry entry : deleteSchemas.entrySet()) {
                DeleteSetInfo deleteGroupInfo = (DeleteSetInfo)entry.getValue();
                List<Types.NestedField> deleteFields = deleteGroupInfo.equalityFieldIds.stream().map(fieldId -> icebergTable.schema().findField(fieldId.intValue())).filter(Objects::nonNull).collect(Collectors.toList());
                VariableReferenceExpression joinSequenceNumber = this.toVariableReference(IcebergColumnHandle.DATA_SEQUENCE_NUMBER_COLUMN_HANDLE);
                deleteVersionColumns.add(joinSequenceNumber);
                ImmutableMap deleteColumnAssignments = ImmutableMap.builder().putAll(deleteGroupInfo.allFields(icebergTable.schema()).stream().collect(Collectors.toMap(this::toVariableReference, this::toIcebergColumnHandle))).put((Object)joinSequenceNumber, (Object)IcebergColumnHandle.DATA_SEQUENCE_NUMBER_COLUMN_HANDLE).build();
                Set clauses = deleteColumnAssignments.entrySet().stream().filter(assignment -> !IcebergMetadataColumn.isMetadataColumnId(((IcebergColumnHandle)((Object)((Object)assignment.getValue()))).getId())).map(assignment -> {
                    VariableReferenceExpression left = (VariableReferenceExpression)reverseAssignmentsMap.get(((IcebergColumnHandle)((Object)((Object)assignment.getValue()))).getId());
                    VariableReferenceExpression right = (VariableReferenceExpression)assignment.getKey();
                    return new EquiJoinClause(left, right);
                }).collect(Collectors.toSet());
                FunctionHandle lessThan = this.functionResolution.comparisonFunction(OperatorType.LESS_THAN, (com.facebook.presto.common.type.Type)BigintType.BIGINT, (com.facebook.presto.common.type.Type)BigintType.BIGINT);
                CallExpression versionFilter = new CallExpression(lessThan.getName(), lessThan, (com.facebook.presto.common.type.Type)BooleanType.BOOLEAN, Collections.unmodifiableList(Arrays.asList(reverseAssignmentsMap.get(IcebergMetadataColumn.DATA_SEQUENCE_NUMBER.getId()), joinSequenceNumber)));
                TableScanNode deleteTableScan = this.createDeletesTableScan((ImmutableMap<VariableReferenceExpression, ColumnHandle>)deleteColumnAssignments, icebergTableHandle, tableName, deleteFields, table, deleteGroupInfo);
                parentNode = new ConnectorJoinNode(this.idAllocator.getNextId(), Arrays.asList(parentNode, deleteTableScan), Optional.empty(), JoinType.LEFT, clauses, (Set)Sets.newHashSet((Object[])new RowExpression[]{versionFilter}), Optional.empty(), Stream.concat(parentNode.getOutputVariables().stream(), deleteTableScan.getOutputVariables().stream()).collect(Collectors.toList()));
            }
            FilterNode filter = new FilterNode(Optional.empty(), this.idAllocator.getNextId(), Optional.empty(), (PlanNode)parentNode, (RowExpression)new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, (com.facebook.presto.common.type.Type)BooleanType.BOOLEAN, new RowExpression[]{new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, (com.facebook.presto.common.type.Type)BigintType.BIGINT, deleteVersionColumns)}));
            Assignments.Builder assignmentsBuilder = Assignments.builder();
            filter.getOutputVariables().stream().filter(variableReferenceExpression -> !variableReferenceExpression.getName().startsWith(IcebergColumnHandle.DATA_SEQUENCE_NUMBER_COLUMN_HANDLE.getName())).forEach(variableReferenceExpression -> assignmentsBuilder.put(variableReferenceExpression, (RowExpression)variableReferenceExpression));
            return new ProjectNode(Optional.empty(), this.idAllocator.getNextId(), (PlanNode)filter, assignmentsBuilder.build(), ProjectNode.Locality.LOCAL);
        }

        private static ImmutableMap<Set<Integer>, DeleteSetInfo> collectDeleteInformation(Table icebergTable, IcebergTableHandle icebergTableHandle, long snapshotId) {
            HashMap deleteInformations = new HashMap();
            try (CloseableIterator files = IcebergUtil.getDeleteFiles(icebergTable, snapshotId, icebergTableHandle.getPredicate(), Optional.empty(), Optional.empty()).iterator();){
                files.forEachRemaining(delete -> {
                    if (FileContent.fromIcebergFileContent(delete.content()) == FileContent.EQUALITY_DELETES) {
                        ImmutableMap.Builder partitionFieldsBuilder = new ImmutableMap.Builder();
                        PartitionSpec partitionSpec = (PartitionSpec)icebergTable.specs().get(delete.specId());
                        Types.StructType partitionType = partitionSpec.partitionType();
                        partitionSpec.fields().forEach(f -> partitionFieldsBuilder.put((Object)f.fieldId(), (Object)new PartitionFieldInfo(partitionType.field(f.fieldId()), (PartitionField)f)));
                        ImmutableMap partitionFields = partitionFieldsBuilder.build();
                        HashSet result = new HashSet();
                        result.addAll(delete.equalityFieldIds());
                        result.addAll(partitionFields.keySet());
                        deleteInformations.put(ImmutableSet.copyOf(result), new DeleteSetInfo(partitionFields, delete.equalityFieldIds()));
                    }
                });
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to read equality delete information", (Throwable)e);
            }
            return ImmutableMap.copyOf(deleteInformations);
        }

        private TableScanNode createDeletesTableScan(ImmutableMap<VariableReferenceExpression, ColumnHandle> deleteColumnAssignments, IcebergTableHandle icebergTableHandle, IcebergTableName tableName, List<Types.NestedField> deleteFields, TableHandle table, DeleteSetInfo deleteInfo) {
            ImmutableList outputs = deleteColumnAssignments.keySet().asList();
            IcebergTableHandle deletesTableHandle = new IcebergTableHandle(icebergTableHandle.getSchemaName(), new IcebergTableName(tableName.getTableName(), IcebergTableType.EQUALITY_DELETES, tableName.getSnapshotId(), Optional.empty()), icebergTableHandle.isSnapshotSpecified(), icebergTableHandle.getPredicate(), Optional.of(SchemaParser.toJson((Schema)new Schema(deleteFields))), Optional.of(deleteInfo.partitionFields.keySet()), Optional.of(deleteInfo.equalityFieldIds));
            return new TableScanNode(Optional.empty(), this.idAllocator.getNextId(), new TableHandle(table.getConnectorId(), (ConnectorTableHandle)deletesTableHandle, table.getTransaction(), table.getLayout(), table.getDynamicFilter()), (List)outputs, deleteColumnAssignments, TupleDomain.all(), TupleDomain.all());
        }

        private TableScanNode createNewRoot(TableScanNode node, IcebergTableHandle icebergTableHandle, IcebergTableName tableName, ImmutableMap<VariableReferenceExpression, ColumnHandle> unselectedAssignments, TableHandle table) {
            IcebergTableHandle updatedHandle = new IcebergTableHandle(icebergTableHandle.getSchemaName(), new IcebergTableName(tableName.getTableName(), IcebergTableType.DATA_WITHOUT_EQUALITY_DELETES, tableName.getSnapshotId(), tableName.getChangelogEndSnapshot()), icebergTableHandle.isSnapshotSpecified(), icebergTableHandle.getPredicate(), icebergTableHandle.getTableSchemaJson(), icebergTableHandle.getPartitionSpecId(), icebergTableHandle.getEqualityFieldIds());
            VariableReferenceExpression dataSequenceNumberVariableReference = this.toVariableReference(IcebergColumnHandle.DATA_SEQUENCE_NUMBER_COLUMN_HANDLE);
            ImmutableMap.Builder assignmentsBuilder = ImmutableMap.builder().put((Object)dataSequenceNumberVariableReference, (Object)IcebergColumnHandle.DATA_SEQUENCE_NUMBER_COLUMN_HANDLE).putAll(unselectedAssignments).putAll(node.getAssignments());
            ImmutableList.Builder outputsBuilder = ImmutableList.builder();
            outputsBuilder.addAll((Iterable)node.getOutputVariables());
            if (!node.getAssignments().containsKey(dataSequenceNumberVariableReference)) {
                outputsBuilder.add((Object)dataSequenceNumberVariableReference);
            }
            outputsBuilder.addAll((Iterable)unselectedAssignments.keySet());
            return new TableScanNode(node.getSourceLocation(), node.getId(), Optional.of(node), new TableHandle(table.getConnectorId(), (ConnectorTableHandle)updatedHandle, table.getTransaction(), table.getLayout(), table.getDynamicFilter()), (List)outputsBuilder.build(), (Map)assignmentsBuilder.build(), node.getTableConstraints(), node.getCurrentConstraint(), node.getEnforcedConstraint());
        }

        private ImmutableMap<VariableReferenceExpression, ColumnHandle> createAssignmentsForUnselectedFields(TableScanNode node, ImmutableMap<Set<Integer>, DeleteSetInfo> deleteInfos, Table icebergTable) {
            Set selectedFields = node.getAssignments().values().stream().map(f -> ((IcebergColumnHandle)((Object)f)).getId()).collect(Collectors.toSet());
            Sets.SetView unselectedFields = Sets.difference((Set)deleteInfos.keySet().stream().reduce(Sets::union).orElseGet(Collections::emptySet), selectedFields);
            ImmutableMap.Builder unselectedAssignmentsBuilder = ImmutableMap.builder();
            Map<Integer, PartitionFieldInfo> partitionFields = deleteInfos.values().stream().flatMap(info -> info.getPartitionFields().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing));
            unselectedFields.forEach(fieldId -> {
                if (partitionFields.containsKey(fieldId)) {
                    PartitionFieldInfo partitionFieldInfo = (PartitionFieldInfo)partitionFields.get(fieldId);
                    PartitionField partitionField = partitionFieldInfo.getPartitionField();
                    Types.NestedField sourceField = icebergTable.schema().findField(partitionField.sourceId());
                    if (!partitionField.transform().isIdentity()) {
                        Type partitionFieldType = partitionField.transform().getResultType(sourceField.type());
                        VariableReferenceExpression variableReference = this.variableAllocator.newVariable(partitionField.name(), TypeConverter.toPrestoType(partitionFieldType, this.typeManager));
                        IcebergColumnHandle columnHandle = new IcebergColumnHandle(ColumnIdentity.createColumnIdentity(partitionField.name(), partitionField.fieldId(), partitionFieldType), TypeConverter.toPrestoType(partitionFieldType, this.typeManager), Optional.empty(), BaseHiveColumnHandle.ColumnType.PARTITION_KEY);
                        unselectedAssignmentsBuilder.put((Object)variableReference, (Object)columnHandle);
                    } else if (!selectedFields.contains(sourceField.fieldId())) {
                        unselectedAssignmentsBuilder.put((Object)this.variableAllocator.newVariable(sourceField.name(), TypeConverter.toPrestoType(sourceField.type(), this.typeManager)), (Object)IcebergColumnHandle.create(sourceField, this.typeManager, BaseHiveColumnHandle.ColumnType.REGULAR));
                    }
                } else {
                    Types.NestedField schemaField = icebergTable.schema().findField(fieldId.intValue());
                    unselectedAssignmentsBuilder.put((Object)this.variableAllocator.newVariable(schemaField.name(), TypeConverter.toPrestoType(schemaField.type(), this.typeManager)), (Object)IcebergColumnHandle.create(schemaField, this.typeManager, BaseHiveColumnHandle.ColumnType.REGULAR));
                }
            });
            return unselectedAssignmentsBuilder.build();
        }

        private VariableReferenceExpression toVariableReference(IcebergColumnHandle columnHandle) {
            return this.variableAllocator.newVariable(columnHandle.getName(), columnHandle.getType());
        }

        private IcebergColumnHandle toIcebergColumnHandle(Types.NestedField field) {
            ColumnIdentity columnIdentity = new ColumnIdentity(field.fieldId(), field.name(), ColumnIdentity.TypeCategory.PRIMITIVE, Collections.emptyList());
            return new IcebergColumnHandle(columnIdentity, TypeConverter.toPrestoType(field.type(), this.typeManager), Optional.empty(), BaseHiveColumnHandle.ColumnType.REGULAR);
        }

        private VariableReferenceExpression toVariableReference(Types.NestedField field) {
            return this.variableAllocator.newVariable(field.name(), TypeConverter.toPrestoType(field.type(), this.typeManager));
        }

        private static class DeleteSetInfo {
            private final ImmutableMap<Integer, PartitionFieldInfo> partitionFields;
            private final Set<Integer> equalityFieldIds;

            private DeleteSetInfo(ImmutableMap<Integer, PartitionFieldInfo> partitionFields, List<Integer> equalityFieldIds) {
                this.partitionFields = Objects.requireNonNull(partitionFields, "partitionFields is null");
                this.equalityFieldIds = ImmutableSet.copyOf((Collection)Objects.requireNonNull(equalityFieldIds, "equalityFieldIds is null"));
            }

            public ImmutableMap<Integer, PartitionFieldInfo> getPartitionFields() {
                return this.partitionFields;
            }

            public List<Types.NestedField> allFields(Schema schema) {
                return Stream.concat(this.equalityFieldIds.stream().map(arg_0 -> ((Schema)schema).findField(arg_0)), this.partitionFields.values().stream().map(partitionFieldInfo -> {
                    if (((PartitionFieldInfo)partitionFieldInfo).partitionField.transform().isIdentity()) {
                        return schema.findField(((PartitionFieldInfo)partitionFieldInfo).partitionField.sourceId());
                    }
                    return ((PartitionFieldInfo)partitionFieldInfo).nestedField;
                })).distinct().collect(Collectors.toList());
            }
        }

        private static class PartitionFieldInfo {
            private final Types.NestedField nestedField;
            private final PartitionField partitionField;

            private PartitionFieldInfo(Types.NestedField nestedField, PartitionField partitionField) {
                this.nestedField = nestedField;
                this.partitionField = partitionField;
            }

            public PartitionField getPartitionField() {
                return this.partitionField;
            }
        }
    }
}

