/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.optimizer;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.rule.BaseSubfieldExtractionRewriter;
import com.facebook.presto.hive.rule.FilterPushdownUtils;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.Table;

public class IcebergFilterPushdown
implements ConnectorPlanOptimizer {
    private final RowExpressionService rowExpressionService;
    private final StandardFunctionResolution functionResolution;
    private final FunctionMetadataManager functionMetadataManager;
    private final TypeManager typeManager;
    private final IcebergTransactionManager icebergTransactionManager;

    public IcebergFilterPushdown(RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager, IcebergTransactionManager transactionManager, TypeManager typeManager) {
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        this.icebergTransactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        if (!IcebergSessionProperties.isPushdownFilterEnabled(session)) {
            return maxSubplan;
        }
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new SubfieldExtractionRewriter(session, idAllocator, this.rowExpressionService, this.functionResolution, this.functionMetadataManager, this.icebergTransactionManager, this.typeManager), (PlanNode)maxSubplan);
    }

    private static ConnectorMetadata getConnectorMetadata(IcebergTransactionManager icebergTransactionManager, TableHandle tableHandle) {
        Objects.requireNonNull(icebergTransactionManager, "icebergTransactionManager is null");
        ConnectorMetadata metadata = icebergTransactionManager.get(tableHandle.getTransaction());
        Preconditions.checkState((boolean)(metadata instanceof IcebergAbstractMetadata), (Object)"metadata must be IcebergAbstractMetadata");
        return metadata;
    }

    public static class SubfieldExtractionRewriter
    extends BaseSubfieldExtractionRewriter {
        private final TypeManager typeManager;

        public SubfieldExtractionRewriter(ConnectorSession session, PlanNodeIdAllocator idAllocator, RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager, IcebergTransactionManager icebergTransactionManager, TypeManager typeManager) {
            super(session, idAllocator, rowExpressionService, functionResolution, functionMetadataManager, tableHandle -> IcebergFilterPushdown.getConnectorMetadata(icebergTransactionManager, tableHandle));
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected BaseSubfieldExtractionRewriter.ConnectorPushdownFilterResult getConnectorPushdownFilterResult(Map<String, ColumnHandle> columnHandles, ConnectorMetadata metadata, ConnectorSession session, BaseSubfieldExtractionRewriter.RemainingExpressions remainingExpressions, DomainTranslator.ExtractionResult<Subfield> decomposedFilter, RowExpression optimizedRemainingExpression, Constraint<ColumnHandle> constraint, Optional<ConnectorTableLayoutHandle> currentLayoutHandle, ConnectorTableHandle tableHandle) {
            Preconditions.checkArgument((boolean)(metadata instanceof IcebergAbstractMetadata), (Object)"metadata must be IcebergAbstractMetadata");
            Preconditions.checkArgument((boolean)(tableHandle instanceof IcebergTableHandle), (Object)"tableHandle must be IcebergTableHandle");
            Table icebergTable = IcebergUtil.getIcebergTable(metadata, session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
            TupleDomain unenforcedConstraint = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)constraint.getSummary().getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(IcebergUtil.getPartitionKeyColumnHandles(icebergTable, this.typeManager)))));
            TupleDomain domainPredicate = FilterPushdownUtils.getDomainPredicate(decomposedFilter, (TupleDomain)unenforcedConstraint);
            Set predicateColumnNames = FilterPushdownUtils.getPredicateColumnNames((RowExpression)optimizedRemainingExpression, (TupleDomain)domainPredicate);
            Map predicateColumns = (Map)predicateColumnNames.stream().map(columnHandles::get).map(IcebergColumnHandle.class::cast).collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, (Function)Functions.identity()));
            Optional<Set<IcebergColumnHandle>> requestedColumns = currentLayoutHandle.map(layout -> ((IcebergTableLayoutHandle)((Object)layout)).getRequestedColumns()).orElse(Optional.empty());
            List<IcebergColumnHandle> partitionColumns = IcebergUtil.getPartitionKeyColumnHandles(icebergTable, this.typeManager);
            TupleDomain partitionColumnPredicate = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)constraint.getSummary().getDomains().get()), (Predicate)Predicates.in(partitionColumns)));
            List<HivePartition> partitions = IcebergUtil.getPartitions(this.typeManager, tableHandle, icebergTable, constraint, partitionColumns);
            return new BaseSubfieldExtractionRewriter.ConnectorPushdownFilterResult(metadata.getTableLayout(session, (ConnectorTableLayoutHandle)new IcebergTableLayoutHandle.Builder().setPartitionColumns((List<BaseHiveColumnHandle>)ImmutableList.copyOf(partitionColumns)).setDataColumns(IcebergUtil.toHiveColumns(icebergTable.schema().columns())).setDomainPredicate((TupleDomain<Subfield>)domainPredicate).setRemainingPredicate(remainingExpressions.getRemainingExpression()).setPredicateColumns(predicateColumns).setRequestedColumns(requestedColumns).setPushdownFilterEnabled(true).setPartitionColumnPredicate((TupleDomain<ColumnHandle>)partitionColumnPredicate).setPartitions(Optional.ofNullable(partitions.size() == 0 ? null : partitions)).setTable((IcebergTableHandle)tableHandle).build()), remainingExpressions.getDynamicFilterExpression());
        }

        protected boolean isPushdownFilterSupported(ConnectorSession session, TableHandle tableHandle) {
            return IcebergSessionProperties.isPushdownFilterEnabled(session);
        }
    }
}

