/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.optimizer;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Table;

public class IcebergPlanOptimizer
implements ConnectorPlanOptimizer {
    private final RowExpressionService rowExpressionService;
    private final StandardFunctionResolution functionResolution;
    private final FunctionMetadataManager functionMetadataManager;
    private final IcebergTransactionManager transactionManager;

    IcebergPlanOptimizer(StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, FunctionMetadataManager functionMetadataManager, IcebergTransactionManager transactionManager) {
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        if (IcebergSessionProperties.isPushdownFilterEnabled(session)) {
            return maxSubplan;
        }
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new FilterPushdownRewriter(this.functionResolution, this.rowExpressionService, this.functionMetadataManager, this.transactionManager, idAllocator, session), (PlanNode)maxSubplan);
    }

    private static Set<IcebergColumnHandle> getIdentityPartitionColumnHandles(Table table, List<IcebergColumnHandle> allColumns) {
        Map idToColumnsMap = allColumns.stream().filter(icebergColumnHandle -> icebergColumnHandle.getColumnType() != BaseHiveColumnHandle.ColumnType.SYNTHESIZED).collect(Collectors.toMap(IcebergColumnHandle::getId, Function.identity()));
        return table.specs().values().stream().map(partitionSpec -> partitionSpec.fields().stream().filter(field -> field.transform().isIdentity()).map(PartitionField::sourceId).filter(idToColumnsMap::containsKey).map(idToColumnsMap::get).collect(Collectors.toSet())).reduce((columnHandleSet1, columnHandleSet2) -> (ImmutableSet)columnHandleSet1.stream().filter(columnHandleSet2::contains).collect(ImmutableSet.toImmutableSet())).orElse((Set)ImmutableSet.of());
    }

    private static class FilterPushdownRewriter
    extends ConnectorPlanRewriter<Void> {
        private final ConnectorSession session;
        private final RowExpressionService rowExpressionService;
        private final StandardFunctionResolution functionResolution;
        private final FunctionMetadataManager functionMetadataManager;
        private final PlanNodeIdAllocator idAllocator;
        private final IcebergTransactionManager transactionManager;

        public FilterPushdownRewriter(StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, FunctionMetadataManager functionMetadataManager, IcebergTransactionManager transactionManager, PlanNodeIdAllocator idAllocator, ConnectorSession session) {
            this.functionResolution = functionResolution;
            this.rowExpressionService = rowExpressionService;
            this.functionMetadataManager = functionMetadataManager;
            this.transactionManager = transactionManager;
            this.idAllocator = idAllocator;
            this.session = session;
        }

        public PlanNode visitFilter(FilterNode filter, ConnectorPlanRewriter.RewriteContext<Void> context) {
            if (!(filter.getSource() instanceof TableScanNode)) {
                return this.visitPlan((PlanNode)filter, context);
            }
            TableScanNode tableScan = (TableScanNode)filter.getSource();
            Map<String, IcebergColumnHandle> nameToColumnHandlesMapping = tableScan.getAssignments().entrySet().stream().collect(Collectors.toMap(e -> ((VariableReferenceExpression)e.getKey()).getName(), e -> (IcebergColumnHandle)((Object)((Object)e.getValue()))));
            ImmutableBiMap columnHandleToNameMapping = ImmutableBiMap.copyOf(nameToColumnHandlesMapping).inverse();
            RowExpression filterPredicate = filter.getPredicate();
            Preconditions.checkArgument((!filterPredicate.equals((Object)LogicalRowExpressions.FALSE_CONSTANT) ? 1 : 0) != 0, (Object)"Filter expression 'FALSE' should not be left to handle here");
            DomainTranslator.ExtractionResult decomposedFilter = this.rowExpressionService.getDomainTranslator().fromPredicate(this.session, filterPredicate, new SubfieldExtractor(this.functionResolution, this.rowExpressionService.getExpressionOptimizer(), this.session).toColumnExtractor());
            TupleDomain entireColumnDomain = decomposedFilter.getTupleDomain().transform(subfield -> subfield.getPath().isEmpty() ? subfield.getRootName() : null).transform(nameToColumnHandlesMapping::get);
            TableHandle handle = tableScan.getTable();
            IcebergTableHandle tableHandle = (IcebergTableHandle)handle.getConnectorHandle();
            IcebergAbstractMetadata metadata = (IcebergAbstractMetadata)this.transactionManager.get(handle.getTransaction());
            Table icebergTable = IcebergUtil.getIcebergTable(metadata, this.session, tableHandle.getSchemaTableName());
            SubfieldExtractor subfieldExtractor = new SubfieldExtractor(this.functionResolution, this.rowExpressionService.getExpressionOptimizer(), this.session);
            Map columnTypes = (Map)nameToColumnHandlesMapping.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (String)entry.getKey(), entry -> ((IcebergColumnHandle)((Object)((Object)entry.getValue()))).getType()));
            TupleDomain subfieldTupleDomain = decomposedFilter.getTupleDomain().transform(subfield -> subfield.getPath().isEmpty() ? null : subfield).transform(subfield -> subfieldExtractor.toRowExpression(subfield, (Type)columnTypes.get(subfield.getRootName())));
            RowExpression subfieldPredicate = this.rowExpressionService.getDomainTranslator().toPredicate(subfieldTupleDomain);
            Set identityPartitionColumns = IcebergPlanOptimizer.getIdentityPartitionColumnHandles(icebergTable, nameToColumnHandlesMapping.values().stream().collect(Collectors.toList()));
            TupleDomain identityPartitionColumnPredicate = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)entireColumnDomain.transform(icebergColumnHandle -> icebergColumnHandle).getDomains().get()), (Predicate)Predicates.in((Collection)identityPartitionColumns)));
            TupleDomain nonPartitionColumnPredicate = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)entireColumnDomain.transform(icebergColumnHandle -> icebergColumnHandle).getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)identityPartitionColumns)))).transform(arg_0 -> FilterPushdownRewriter.lambda$visitFilter$9((Map)columnHandleToNameMapping, arg_0)).transform(subfield -> subfieldExtractor.toRowExpression(subfield, (Type)columnTypes.get(subfield.getRootName())));
            RowExpression nonPartitionColumn = this.rowExpressionService.getDomainTranslator().toPredicate(nonPartitionColumnPredicate);
            LogicalRowExpressions logicalRowExpressions = new LogicalRowExpressions(this.rowExpressionService.getDeterminismEvaluator(), this.functionResolution, this.functionMetadataManager);
            RowExpression remainingFilterExpression = logicalRowExpressions.combineConjuncts((Collection)ImmutableList.of((Object)decomposedFilter.getRemainingExpression(), (Object)subfieldPredicate, (Object)nonPartitionColumn));
            TupleDomain simplifiedColumnDomain = entireColumnDomain.simplify();
            boolean predicateNotChangedBySimplification = simplifiedColumnDomain.equals((Object)entireColumnDomain);
            IcebergTableHandle oldTableHandle = (IcebergTableHandle)handle.getConnectorHandle();
            IcebergTableHandle newTableHandle = new IcebergTableHandle(oldTableHandle.getSchemaName(), oldTableHandle.getIcebergTableName(), oldTableHandle.isSnapshotSpecified(), (TupleDomain<IcebergColumnHandle>)simplifiedColumnDomain.intersect(oldTableHandle.getPredicate()), oldTableHandle.getTableSchemaJson(), oldTableHandle.getPartitionSpecId(), oldTableHandle.getEqualityFieldIds());
            TableScanNode newTableScan = new TableScanNode(tableScan.getSourceLocation(), tableScan.getId(), new TableHandle(handle.getConnectorId(), (ConnectorTableHandle)newTableHandle, handle.getTransaction(), handle.getLayout()), tableScan.getOutputVariables(), tableScan.getAssignments(), simplifiedColumnDomain.transform(ColumnHandle.class::cast).intersect(tableScan.getCurrentConstraint()), predicateNotChangedBySimplification ? identityPartitionColumnPredicate.intersect(tableScan.getEnforcedConstraint()) : tableScan.getEnforcedConstraint());
            if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)remainingFilterExpression) && predicateNotChangedBySimplification) {
                return newTableScan;
            }
            if (predicateNotChangedBySimplification) {
                return new FilterNode(filter.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)newTableScan, remainingFilterExpression);
            }
            return new FilterNode(filter.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)newTableScan, filterPredicate);
        }

        private static /* synthetic */ Subfield lambda$visitFilter$9(Map columnHandleToNameMapping, ColumnHandle columnHandle) {
            return new Subfield((String)columnHandleToNameMapping.get(columnHandle), (List)ImmutableList.of());
        }
    }
}

