/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.optimizer;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.iceberg.optimizer.IcebergEqualityDeleteAsJoin;
import com.facebook.presto.iceberg.optimizer.IcebergFilterPushdown;
import com.facebook.presto.iceberg.optimizer.IcebergParquetDereferencePushDown;
import com.facebook.presto.iceberg.optimizer.IcebergPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Objects;
import java.util.Set;

public class IcebergPlanOptimizerProvider
implements ConnectorPlanOptimizerProvider {
    private final Set<ConnectorPlanOptimizer> planOptimizers;
    private final Set<ConnectorPlanOptimizer> logicalPlanOptimizers;

    @Inject
    public IcebergPlanOptimizerProvider(IcebergTransactionManager transactionManager, RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager, TypeManager typeManager) {
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        Objects.requireNonNull(functionResolution, "functionResolution is null");
        Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.planOptimizers = ImmutableSet.of((Object)new IcebergPlanOptimizer(functionResolution, rowExpressionService, functionMetadataManager, transactionManager), (Object)new IcebergFilterPushdown(rowExpressionService, functionResolution, functionMetadataManager, transactionManager, typeManager), (Object)((Object)new IcebergParquetDereferencePushDown(transactionManager, rowExpressionService, typeManager)));
        this.logicalPlanOptimizers = ImmutableSet.builder().addAll(this.planOptimizers).add((Object)new IcebergEqualityDeleteAsJoin(functionResolution, transactionManager, typeManager)).build();
    }

    public Set<ConnectorPlanOptimizer> getLogicalPlanOptimizers() {
        return this.logicalPlanOptimizers;
    }

    public Set<ConnectorPlanOptimizer> getPhysicalPlanOptimizers() {
        return this.planOptimizers;
    }
}

