/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.util;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;

public final class PageListBuilder {
    private final int channels;
    private final PageBuilder pageBuilder;
    private ImmutableList.Builder<Page> pages;
    private int channel;

    public PageListBuilder(List<Type> types) {
        this.channels = types.size();
        this.pageBuilder = new PageBuilder(types);
        this.reset();
    }

    public void reset() {
        this.pages = ImmutableList.builder();
        this.pageBuilder.reset();
        this.channel = -1;
    }

    public List<Page> build() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"cannot be in row");
        if (!this.pageBuilder.isEmpty()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return this.pages.build();
    }

    public void beginRow() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"already in row");
        if (this.pageBuilder.isFull()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.pageBuilder.declarePosition();
        this.channel = 0;
    }

    public void endRow() {
        Preconditions.checkArgument((this.channel == this.channels ? 1 : 0) != 0, (Object)"not at end of row");
        this.channel = -1;
    }

    public void appendNull() {
        this.nextColumn().appendNull();
    }

    public void appendInteger(int value) {
        IntegerType.INTEGER.writeLong(this.nextColumn(), (long)value);
    }

    public void appendBigint(long value) {
        BigintType.BIGINT.writeLong(this.nextColumn(), value);
    }

    public void appendTimestampTzMillis(long millisUtc, TimeZoneKey timeZoneKey) {
        TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.writeLong(this.nextColumn(), DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)timeZoneKey));
    }

    public void appendVarchar(String value) {
        VarcharType.VARCHAR.writeString(this.nextColumn(), value);
    }

    public void appendVarbinary(Slice value) {
        VarbinaryType.VARBINARY.writeSlice(this.nextColumn(), value);
    }

    public void appendIntegerArray(Iterable<Integer> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder array = column.beginBlockEntry();
        for (Integer value : values) {
            IntegerType.INTEGER.writeLong(array, (long)value.intValue());
        }
        column.closeEntry();
    }

    public void appendBigintArray(Iterable<Long> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder array = column.beginBlockEntry();
        for (Long value : values) {
            BigintType.BIGINT.writeLong(array, value.longValue());
        }
        column.closeEntry();
    }

    public void appendVarcharVarcharMap(Map<String, String> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder map = column.beginBlockEntry();
        values.forEach((key, value) -> {
            VarcharType.VARCHAR.writeString(map, key);
            VarcharType.VARCHAR.writeString(map, value);
        });
        column.closeEntry();
    }

    public void appendIntegerBigintMap(Map<Integer, Long> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder map = column.beginBlockEntry();
        values.forEach((key, value) -> {
            IntegerType.INTEGER.writeLong(map, (long)key.intValue());
            BigintType.BIGINT.writeLong(map, value.longValue());
        });
        column.closeEntry();
    }

    public void appendIntegerVarcharMap(Map<Integer, String> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder map = column.beginBlockEntry();
        values.forEach((key, value) -> {
            IntegerType.INTEGER.writeLong(map, (long)key.intValue());
            VarcharType.VARCHAR.writeString(map, value);
        });
        column.closeEntry();
    }

    public BlockBuilder nextColumn() {
        int currentChannel = this.channel++;
        return this.pageBuilder.getBlockBuilder(currentChannel);
    }

    public static PageListBuilder forTable(ConnectorTableMetadata table) {
        return new PageListBuilder((List)table.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList()));
    }
}

