/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.util;

import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.util.HiveStatisticsMergeStrategy;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import java.util.Map;
import org.apache.iceberg.PartitionSpec;

public final class StatisticsUtil {
    private StatisticsUtil() {
    }

    public static TableStatistics mergeHiveStatistics(TableStatistics icebergStatistics, PartitionStatistics hiveStatistics, HiveStatisticsMergeStrategy mergeStrategy, PartitionSpec spec) {
        if (mergeStrategy.equals((Object)HiveStatisticsMergeStrategy.NONE) || spec.isPartitioned()) {
            return icebergStatistics;
        }
        Map columnStats = hiveStatistics.getColumnStatistics();
        TableStatistics.Builder statsBuilder = TableStatistics.builder();
        statsBuilder.setTotalSize(icebergStatistics.getTotalSize());
        statsBuilder.setRowCount(icebergStatistics.getRowCount());
        icebergStatistics.getColumnStatistics().forEach((columnHandle, icebergColumnStats) -> {
            HiveColumnStatistics hiveColumnStats = (HiveColumnStatistics)columnStats.get(((IcebergColumnHandle)((Object)columnHandle)).getName());
            ColumnStatistics.Builder mergedStats = ColumnStatistics.builder().setDataSize(icebergColumnStats.getDataSize()).setDistinctValuesCount(icebergColumnStats.getDistinctValuesCount()).setRange(icebergColumnStats.getRange()).setNullsFraction(icebergColumnStats.getNullsFraction()).setDistinctValuesCount(icebergColumnStats.getDistinctValuesCount()).setRange(icebergColumnStats.getRange());
            if (hiveColumnStats != null) {
                if (mergeStrategy.equals((Object)HiveStatisticsMergeStrategy.USE_NDV) || mergeStrategy.equals((Object)HiveStatisticsMergeStrategy.USE_NULLS_FRACTION_AND_NDV)) {
                    hiveColumnStats.getDistinctValuesCount().ifPresent(ndvs -> mergedStats.setDistinctValuesCount(Estimate.of((double)ndvs)));
                }
                if (mergeStrategy.equals((Object)HiveStatisticsMergeStrategy.USE_NULLS_FRACTIONS) || mergeStrategy.equals((Object)HiveStatisticsMergeStrategy.USE_NULLS_FRACTION_AND_NDV)) {
                    hiveColumnStats.getNullsCount().ifPresent(nullCount -> {
                        Estimate nullsFraction = !hiveStatistics.getBasicStatistics().getRowCount().isPresent() ? (icebergStatistics.getRowCount().isUnknown() ? Estimate.unknown() : Estimate.of((double)((double)nullCount / icebergStatistics.getRowCount().getValue()))) : Estimate.of((double)((double)nullCount / (double)hiveStatistics.getBasicStatistics().getRowCount().getAsLong()));
                        mergedStats.setNullsFraction(nullsFraction);
                    });
                }
            }
            statsBuilder.setColumnStatistics(columnHandle, mergedStats.build());
        });
        return statsBuilder.build();
    }
}

