package com.facebook.presto.jdbc.internal.jackson.datatype.jdk8;

import com.facebook.presto.jdbc.internal.jackson.core.Version;
import com.facebook.presto.jdbc.internal.jackson.databind.Module;

public class Jdk8Module extends Module
{
    @Override
    public void setupModule(SetupContext context) {
        context.addSerializers(new Jdk8Serializers());
        context.addDeserializers(new Jdk8Deserializers());
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public String getModuleName() {
        return "Jdk8Module";
    }
}
