/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.AsyncContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpContent;
import com.facebook.presto.jdbc.internal.jetty.client.HttpConversation;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequestException;
import com.facebook.presto.jdbc.internal.jetty.client.RequestNotifier;
import com.facebook.presto.jdbc.internal.jetty.client.api.ContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeaderValue;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.IteratingCallback;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class HttpSender
implements AsyncContentProvider.Listener {
    protected static final Logger LOG = Log.getLogger(HttpSender.class);
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<SenderState> senderState = new AtomicReference<SenderState>(SenderState.IDLE);
    private final Callback commitCallback = new CommitCallback();
    private final IteratingCallback contentCallback = new ContentCallback();
    private final Callback lastCallback = new LastContentCallback();
    private final HttpChannel channel;
    private HttpContent content;
    private Throwable failure;

    protected HttpSender(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onContent() {
        exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        block7: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 1: {
                    newSenderState = SenderState.SENDING;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 2: {
                    newSenderState = SenderState.SENDING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 3: {
                    newSenderState = SenderState.EXPECTING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 4: {
                    newSenderState = SenderState.PROCEEDING_WITH_CONTENT;
                    if (this.updateSenderState(current, newSenderState)) ** break;
                    continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {}", new Object[]{current});
                    }
                    return;
                }
            }
            break;
        }
        this.illegalSenderState(current);
    }

    public void send(HttpExchange exchange) {
        if (!this.queuedToBegin(exchange)) {
            return;
        }
        HttpRequest request = exchange.getRequest();
        ContentProvider contentProvider = request.getContent();
        HttpContent content = this.content = new HttpContent(contentProvider);
        SenderState newSenderState = SenderState.SENDING;
        if (this.expects100Continue(request)) {
            newSenderState = content.hasContent() ? SenderState.EXPECTING_WITH_CONTENT : SenderState.EXPECTING;
        }
        block3: while (true) {
            SenderState current = this.senderState.get();
            switch (current) {
                case IDLE: 
                case COMPLETED: {
                    if (!this.updateSenderState(current, newSenderState)) continue block3;
                    break block3;
                }
                default: {
                    this.illegalSenderState(current);
                    return;
                }
            }
            break;
        }
        if (contentProvider instanceof AsyncContentProvider) {
            ((AsyncContentProvider)contentProvider).setListener(this);
        }
        if (!this.beginToHeaders(exchange)) {
            return;
        }
        this.sendHeaders(exchange, content, this.commitCallback);
    }

    protected boolean expects100Continue(Request request) {
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    protected boolean queuedToBegin(HttpExchange exchange) {
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request begin {}", request);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyBegin(request);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.BEGIN)) {
            return true;
        }
        this.terminateRequest(exchange);
        return false;
    }

    protected boolean beginToHeaders(HttpExchange exchange) {
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", request, System.lineSeparator(), request.getHeaders().toString().trim());
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyHeaders(request);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.HEADERS)) {
            return true;
        }
        this.terminateRequest(exchange);
        return false;
    }

    protected boolean headersToCommit(HttpExchange exchange) {
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request committed {}", request);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyCommit(request);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.COMMIT)) {
            return true;
        }
        this.terminateRequest(exchange);
        return false;
    }

    protected boolean someToContent(HttpExchange exchange, ByteBuffer content) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                if (!this.updateRequestState(current, RequestState.TRANSIENT)) {
                    return false;
                }
                HttpRequest request = exchange.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", request, System.lineSeparator(), BufferUtil.toDetailString(content));
                }
                RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                notifier.notifyContent(request, content);
                if (this.updateRequestState(RequestState.TRANSIENT, RequestState.CONTENT)) {
                    return true;
                }
                this.terminateRequest(exchange);
                return false;
            }
        }
        return false;
    }

    protected boolean someToSuccess(HttpExchange exchange) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                boolean completed = exchange.requestComplete(null);
                if (!completed) {
                    return false;
                }
                this.requestState.set(RequestState.QUEUED);
                this.reset();
                HttpRequest request = exchange.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request success {}", request);
                }
                HttpDestination destination = this.getHttpChannel().getHttpDestination();
                destination.getRequestNotifier().notifySuccess(exchange.getRequest());
                Result result = exchange.terminateRequest();
                this.terminateRequest(exchange, null, result);
                return true;
            }
        }
        return false;
    }

    protected boolean anyToFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        if (exchange.requestComplete(failure)) {
            return this.abort(exchange, failure);
        }
        return false;
    }

    private void terminateRequest(HttpExchange exchange) {
        Throwable failure = this.failure;
        if (failure == null) {
            failure = new HttpRequestException("Concurrent failure", exchange.getRequest());
        }
        Result result = exchange.terminateRequest();
        this.terminateRequest(exchange, failure, result);
    }

    private void terminateRequest(HttpExchange exchange, Throwable failure, Result result) {
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating request {}", request);
        }
        if (result == null) {
            if (failure != null && exchange.responseComplete(failure)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response failure from request {} {}", request, exchange);
                }
                this.getHttpChannel().abortResponse(exchange, failure);
            }
        } else {
            HttpDestination destination = this.getHttpChannel().getHttpDestination();
            boolean ordered = destination.getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", failure == null ? "succeeded" : "failed", result);
            }
            HttpConversation conversation = exchange.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
        }
    }

    protected abstract void sendHeaders(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendContent(HttpExchange var1, HttpContent var2, Callback var3);

    protected void reset() {
        HttpContent content = this.content;
        this.content = null;
        content.close();
        this.senderState.set(SenderState.COMPLETED);
    }

    protected void dispose() {
        HttpContent content = this.content;
        this.content = null;
        if (content != null) {
            content.close();
        }
        this.senderState.set(SenderState.FAILED);
    }

    /*
     * Unable to fully structure code
     */
    public void proceed(HttpExchange exchange, Throwable failure) {
        if (!this.expects100Continue(exchange.getRequest())) {
            return;
        }
        if (failure != null) {
            this.anyToFailure(failure);
            return;
        }
        block6: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 3: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while expecting", new Object[0]);
                    }
                    return;
                }
                case 6: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING_WITH_CONTENT)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while scheduled", new Object[0]);
                    }
                    return;
                }
                case 8: {
                    if (this.updateSenderState(current, SenderState.SENDING)) ** break;
                    continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while waiting", new Object[0]);
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 10: {
                    return;
                }
            }
            break;
        }
        this.illegalSenderState(current);
    }

    public boolean abort(HttpExchange exchange, Throwable failure) {
        RequestState current;
        do {
            current = this.requestState.get();
            switch (current) {
                case FAILURE: {
                    return false;
                }
            }
        } while (!this.updateRequestState(current, RequestState.FAILURE));
        boolean terminate = current != RequestState.TRANSIENT;
        this.failure = failure;
        this.dispose();
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request failure {} {} on {}: {}", request, exchange, this.getHttpChannel(), failure);
        }
        HttpDestination destination = this.getHttpChannel().getHttpDestination();
        destination.getRequestNotifier().notifyFailure(request, failure);
        if (terminate) {
            Result result = exchange.terminateRequest();
            this.terminateRequest(exchange, failure, result);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: request termination skipped, performed by helpers", new Object[0]);
        }
        return true;
    }

    private boolean updateRequestState(RequestState from, RequestState to) {
        boolean updated = this.requestState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{from, to, this.requestState.get()});
        }
        return updated;
    }

    private boolean updateSenderState(SenderState from, SenderState to) {
        boolean updated = this.senderState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            LOG.debug("SenderState update failed: {} -> {}: {}", new Object[]{from, to, this.senderState.get()});
        }
        return updated;
    }

    private void illegalSenderState(SenderState current) {
        this.anyToFailure(new IllegalStateException("Expected " + (Object)((Object)current) + " found " + (Object)((Object)this.senderState.get()) + " instead"));
    }

    public String toString() {
        return String.format("%s@%x(req=%s,snd=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.requestState, this.senderState, this.failure);
    }

    private class LastContentCallback
    implements Callback {
        private LastContentCallback() {
        }

        @Override
        public void succeeded() {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.succeeded();
            HttpSender.this.someToSuccess(exchange);
        }

        @Override
        public void failed(Throwable failure) {
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private ContentCallback() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            SenderState current;
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return IteratingCallback.Action.IDLE;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return IteratingCallback.Action.IDLE;
            }
            block4: while (true) {
                boolean advanced = content.advance();
                boolean consumed = content.isConsumed();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content {} consumed {} for {}", advanced, consumed, exchange.getRequest());
                }
                if (advanced) {
                    HttpSender.this.sendContent(exchange, content, this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (consumed) {
                    HttpSender.this.sendContent(exchange, content, HttpSender.this.lastCallback);
                    return IteratingCallback.Action.IDLE;
                }
                current = (SenderState)((Object)HttpSender.this.senderState.get());
                switch (current) {
                    case SENDING: {
                        if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Content is deferred for {}", exchange.getRequest());
                        }
                        return IteratingCallback.Action.IDLE;
                    }
                    case SENDING_WITH_CONTENT: {
                        HttpSender.this.updateSenderState(current, SenderState.SENDING);
                        continue block4;
                    }
                }
                break;
            }
            HttpSender.this.illegalSenderState(current);
            return IteratingCallback.Action.IDLE;
        }

        @Override
        public void succeeded() {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.succeeded();
            ByteBuffer buffer = content.getContent();
            HttpSender.this.someToContent(exchange, buffer);
            super.succeeded();
        }

        @Override
        public void onCompleteFailure(Throwable failure) {
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        @Override
        protected void onCompleteSuccess() {
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        @Override
        public void succeeded() {
            try {
                HttpContent content = HttpSender.this.content;
                if (content == null) {
                    return;
                }
                content.succeeded();
                this.process();
            }
            catch (Throwable x) {
                HttpSender.this.anyToFailure(x);
            }
        }

        @Override
        public void failed(Throwable failure) {
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        private void process() throws Exception {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            if (!HttpSender.this.headersToCommit(exchange)) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            if (content.hasContent()) {
                SenderState current;
                ByteBuffer contentBuffer = content.getContent();
                if (contentBuffer != null && !HttpSender.this.someToContent(exchange, contentBuffer)) {
                    return;
                }
                block9: while (true) {
                    current = (SenderState)((Object)HttpSender.this.senderState.get());
                    switch (current) {
                        case SENDING: {
                            HttpSender.this.contentCallback.iterate();
                            return;
                        }
                        case SENDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block9;
                        }
                        case EXPECTING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block9;
                            return;
                        }
                        case EXPECTING_WITH_CONTENT: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block9;
                            return;
                        }
                        case PROCEEDING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block9;
                            return;
                        }
                        case PROCEEDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block9;
                        }
                        case FAILED: {
                            return;
                        }
                    }
                    break;
                }
                HttpSender.this.illegalSenderState(current);
                return;
            }
            HttpSender.this.someToSuccess(exchange);
        }
    }

    private static enum SenderState {
        IDLE,
        SENDING,
        SENDING_WITH_CONTENT,
        EXPECTING,
        EXPECTING_WITH_CONTENT,
        WAITING,
        PROCEEDING,
        PROCEEDING_WITH_CONTENT,
        COMPLETED,
        FAILED;

    }

    private static enum RequestState {
        TRANSIENT,
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

