/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.io.ssl;

import com.facebook.presto.jdbc.internal.jetty.io.AbstractConnection;
import com.facebook.presto.jdbc.internal.jetty.io.AbstractEndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.FillInterest;
import com.facebook.presto.jdbc.internal.jetty.io.RuntimeIOException;
import com.facebook.presto.jdbc.internal.jetty.io.WriteFlusher;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(SslConnection.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final ByteBuffer __FILL_CALLED_FLUSH = BufferUtil.allocate(0);
    private static final ByteBuffer __FLUSH_CALLED_FILL = BufferUtil.allocate(0);
    private final ByteBufferPool _bufferPool;
    private final SSLEngine _sslEngine;
    private final DecryptedEndPoint _decryptedEndPoint;
    private ByteBuffer _decryptedInput;
    private ByteBuffer _encryptedInput;
    private ByteBuffer _encryptedOutput;
    private final boolean _encryptedDirectBuffers = false;
    private final boolean _decryptedDirectBuffers = false;
    private final Runnable _runCompletWrite = new Runnable(){

        @Override
        public void run() {
            SslConnection.this._decryptedEndPoint.getWriteFlusher().completeWrite();
        }
    };
    private boolean _renegotiationAllowed;

    public SslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sslEngine) {
        super(endPoint, executor, false);
        this._bufferPool = byteBufferPool;
        this._sslEngine = sslEngine;
        this._decryptedEndPoint = this.newDecryptedEndPoint();
    }

    protected DecryptedEndPoint newDecryptedEndPoint() {
        return new DecryptedEndPoint();
    }

    public SSLEngine getSSLEngine() {
        return this._sslEngine;
    }

    public DecryptedEndPoint getDecryptedEndPoint() {
        return this._decryptedEndPoint;
    }

    public boolean isRenegotiationAllowed() {
        return this._renegotiationAllowed;
    }

    public void setRenegotiationAllowed(boolean renegotiationAllowed) {
        this._renegotiationAllowed = renegotiationAllowed;
    }

    @Override
    public void onOpen() {
        try {
            this._sslEngine.beginHandshake();
            super.onOpen();
            this.getDecryptedEndPoint().getConnection().onOpen();
        }
        catch (SSLException x) {
            this.getEndPoint().close();
            throw new RuntimeIOException(x);
        }
    }

    @Override
    public void onClose() {
        this._decryptedEndPoint.getConnection().onClose();
        super.onClose();
    }

    @Override
    public void close() {
        this.getDecryptedEndPoint().getConnection().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillable() {
        if (DEBUG) {
            LOG.debug("onFillable enter {}", this._decryptedEndPoint);
        }
        if (this._decryptedEndPoint.isInputShutdown()) {
            this._decryptedEndPoint.close();
        }
        this._decryptedEndPoint.getFillInterest().fillable();
        DecryptedEndPoint decryptedEndPoint = this._decryptedEndPoint;
        synchronized (decryptedEndPoint) {
            if (this._decryptedEndPoint._flushRequiresFillToProgress) {
                this._decryptedEndPoint._flushRequiresFillToProgress = false;
                this.getExecutor().execute(this._runCompletWrite);
            }
        }
        if (DEBUG) {
            LOG.debug("onFillable exit {}", this._decryptedEndPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillInterestedFailed(Throwable cause) {
        this._decryptedEndPoint.getFillInterest().onFail(cause);
        boolean failFlusher = false;
        DecryptedEndPoint decryptedEndPoint = this._decryptedEndPoint;
        synchronized (decryptedEndPoint) {
            if (this._decryptedEndPoint._flushRequiresFillToProgress) {
                this._decryptedEndPoint._flushRequiresFillToProgress = false;
                failFlusher = true;
            }
        }
        if (failFlusher) {
            this._decryptedEndPoint.getWriteFlusher().onFail(cause);
        }
    }

    @Override
    public String toString() {
        ByteBuffer b = this._encryptedInput;
        int ei = b == null ? -1 : b.remaining();
        b = this._encryptedOutput;
        int eo = b == null ? -1 : b.remaining();
        b = this._decryptedInput;
        int di = b == null ? -1 : b.remaining();
        return String.format("SslConnection@%x{%s,eio=%d/%d,di=%d} -> %s", new Object[]{this.hashCode(), this._sslEngine.getHandshakeStatus(), ei, eo, di, this._decryptedEndPoint.getConnection()});
    }

    static /* synthetic */ ByteBuffer access$1402(SslConnection x0, ByteBuffer x1) {
        x0._encryptedInput = x1;
        return x0._encryptedInput;
    }

    static /* synthetic */ ByteBuffer access$1302(SslConnection x0, ByteBuffer x1) {
        x0._decryptedInput = x1;
        return x0._decryptedInput;
    }

    static /* synthetic */ ByteBuffer access$1600() {
        return __FLUSH_CALLED_FILL;
    }

    static /* synthetic */ ByteBuffer access$1700() {
        return __FILL_CALLED_FLUSH;
    }

    static /* synthetic */ Executor access$1800(SslConnection x0) {
        return x0.getExecutor();
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus;
        static final /* synthetic */ int[] $SwitchMap$javax$net$ssl$SSLEngineResult$Status;

        static {
            $SwitchMap$javax$net$ssl$SSLEngineResult$Status = new int[SSLEngineResult.Status.values().length];
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.BUFFER_UNDERFLOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.OK.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus = new int[SSLEngineResult.HandshakeStatus.values().length];
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_TASK.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_WRAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_UNWRAP.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.FINISHED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public class DecryptedEndPoint
    extends AbstractEndPoint {
        private boolean _fillRequiresFlushToProgress;
        private boolean _flushRequiresFillToProgress;
        private boolean _cannotAcceptMoreAppDataToFlush;
        private boolean _handshaken;
        private boolean _underFlown;
        private final Callback _writeCallback;

        public DecryptedEndPoint() {
            super(null, SslConnection.this.getEndPoint().getLocalAddress(), SslConnection.this.getEndPoint().getRemoteAddress());
            this._writeCallback = new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void succeeded() {
                    boolean fillable = false;
                    DecryptedEndPoint decryptedEndPoint = DecryptedEndPoint.this;
                    synchronized (decryptedEndPoint) {
                        if (DEBUG) {
                            LOG.debug("write.complete {}", SslConnection.this.getEndPoint());
                        }
                        DecryptedEndPoint.this.releaseEncryptedOutputBuffer();
                        DecryptedEndPoint.this._cannotAcceptMoreAppDataToFlush = false;
                        if (DecryptedEndPoint.this._fillRequiresFlushToProgress) {
                            DecryptedEndPoint.this._fillRequiresFlushToProgress = false;
                            fillable = true;
                        }
                    }
                    if (fillable) {
                        DecryptedEndPoint.this.getFillInterest().fillable();
                    }
                    SslConnection.this.getExecutor().execute(SslConnection.this._runCompletWrite);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void failed(Throwable x) {
                    boolean fail_filler = false;
                    DecryptedEndPoint decryptedEndPoint = DecryptedEndPoint.this;
                    synchronized (decryptedEndPoint) {
                        if (DEBUG) {
                            LOG.debug("{} write.failed", SslConnection.this, x);
                        }
                        BufferUtil.clear(SslConnection.this._encryptedOutput);
                        DecryptedEndPoint.this.releaseEncryptedOutputBuffer();
                        DecryptedEndPoint.this._cannotAcceptMoreAppDataToFlush = false;
                        if (DecryptedEndPoint.this._fillRequiresFlushToProgress) {
                            DecryptedEndPoint.this._fillRequiresFlushToProgress = false;
                            fail_filler = true;
                        }
                    }
                    final boolean filler_failed = fail_filler;
                    SslConnection.this.failedCallback(new Callback(){

                        @Override
                        public void succeeded() {
                        }

                        @Override
                        public void failed(Throwable x) {
                            if (filler_failed) {
                                DecryptedEndPoint.this.getFillInterest().onFail(x);
                            }
                            DecryptedEndPoint.this.getWriteFlusher().onFail(x);
                        }
                    }, x);
                }
            };
            this.setIdleTimeout(SslConnection.this.getEndPoint().getIdleTimeout());
        }

        @Override
        protected FillInterest getFillInterest() {
            return super.getFillInterest();
        }

        @Override
        public void setIdleTimeout(long idleTimeout) {
            super.setIdleTimeout(idleTimeout);
            SslConnection.this.getEndPoint().setIdleTimeout(idleTimeout);
        }

        @Override
        protected WriteFlusher getWriteFlusher() {
            return super.getWriteFlusher();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onIncompleteFlush() {
            boolean try_again = false;
            DecryptedEndPoint decryptedEndPoint = this;
            synchronized (decryptedEndPoint) {
                if (DEBUG) {
                    LOG.debug("onIncompleteFlush {}", SslConnection.this.getEndPoint());
                }
                if (BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                    this._cannotAcceptMoreAppDataToFlush = true;
                    SslConnection.this.getEndPoint().write(this._writeCallback, SslConnection.this._encryptedOutput);
                } else if (SslConnection.this._sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this._flushRequiresFillToProgress = true;
                    SslConnection.this.fillInterested();
                } else {
                    try_again = true;
                }
            }
            if (try_again) {
                if (this.isOutputShutdown()) {
                    this.getWriteFlusher().onClose();
                } else {
                    SslConnection.this.getExecutor().execute(SslConnection.this._runCompletWrite);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean needsFill() throws IOException {
            DecryptedEndPoint decryptedEndPoint = this;
            synchronized (decryptedEndPoint) {
                if (BufferUtil.hasContent(SslConnection.this._decryptedInput)) {
                    return true;
                }
                if (!BufferUtil.isEmpty(SslConnection.this._encryptedInput) && !this._underFlown) {
                    return true;
                }
                if (this._fillRequiresFlushToProgress) {
                    if (!BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                        this._fillRequiresFlushToProgress = false;
                        return true;
                    }
                    this._cannotAcceptMoreAppDataToFlush = true;
                    SslConnection.this.getEndPoint().write(this._writeCallback, SslConnection.this._encryptedOutput);
                } else {
                    SslConnection.this.fillInterested();
                }
                return false;
            }
        }

        @Override
        public void setConnection(Connection connection) {
            AbstractConnection a;
            if (connection instanceof AbstractConnection && (a = (AbstractConnection)connection).getInputBufferSize() < SslConnection.this._sslEngine.getSession().getApplicationBufferSize()) {
                a.setInputBufferSize(SslConnection.this._sslEngine.getSession().getApplicationBufferSize());
            }
            super.setConnection(connection);
        }

        public SslConnection getSslConnection() {
            return SslConnection.this;
        }

        /*
         * Exception decompiling
         */
        @Override
        public synchronized int fill(ByteBuffer buffer) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void closeInbound() {
            try {
                SslConnection.this._sslEngine.closeInbound();
            }
            catch (SSLException x) {
                LOG.ignore(x);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public synchronized boolean flush(ByteBuffer ... appOuts) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void releaseEncryptedOutputBuffer() {
            if (!Thread.holdsLock(this)) {
                throw new IllegalStateException();
            }
            if (SslConnection.this._encryptedOutput != null && !SslConnection.this._encryptedOutput.hasRemaining()) {
                SslConnection.this._bufferPool.release(SslConnection.this._encryptedOutput);
                SslConnection.this._encryptedOutput = null;
            }
        }

        @Override
        public void shutdownOutput() {
            boolean ishut = this.isInputShutdown();
            boolean oshut = this.isOutputShutdown();
            if (DEBUG) {
                LOG.debug("{} shutdownOutput: oshut={}, ishut={}", SslConnection.this, oshut, ishut);
            }
            if (ishut) {
                SslConnection.this.getEndPoint().close();
            } else if (!oshut) {
                try {
                    SslConnection.this._sslEngine.closeOutbound();
                    this.flush(BufferUtil.EMPTY_BUFFER);
                    SslConnection.this.fillInterested();
                }
                catch (Exception e) {
                    LOG.ignore(e);
                    SslConnection.this.getEndPoint().close();
                }
            }
        }

        @Override
        public boolean isOutputShutdown() {
            return SslConnection.this._sslEngine.isOutboundDone() || SslConnection.this.getEndPoint().isOutputShutdown();
        }

        @Override
        public void close() {
            super.close();
            this.shutdownOutput();
            SslConnection.this.getEndPoint().close();
        }

        @Override
        public boolean isOpen() {
            return SslConnection.this.getEndPoint().isOpen();
        }

        @Override
        public Object getTransport() {
            return SslConnection.this.getEndPoint();
        }

        @Override
        public boolean isInputShutdown() {
            return SslConnection.this._sslEngine.isInboundDone();
        }

        @Override
        public String toString() {
            return super.toString() + "->" + SslConnection.this.getEndPoint().toString();
        }
    }
}

