/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.configuration.ConfigBinder;
import com.facebook.presto.jdbc.internal.airlift.configuration.ConfigDefaults;
import com.facebook.presto.jdbc.internal.airlift.http.client.AbstractHttpClientModule;
import com.facebook.presto.jdbc.internal.airlift.http.client.CompositeQualifier;
import com.facebook.presto.jdbc.internal.airlift.http.client.CompositeQualifierImpl;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClientConfig;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPool;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPoolConfig;
import com.facebook.presto.jdbc.internal.airlift.log.Logger;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.annotations.VisibleForTesting;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.weakref.jmx.guice.ExportBinder;

@Beta
public class HttpClientModule
extends AbstractHttpClientModule {
    private static final Logger log = Logger.get(HttpClientModule.class);
    private ConfigDefaults<HttpClientConfig> configDefaults;

    protected HttpClientModule(String name, Class<? extends Annotation> annotation) {
        super(name, annotation);
    }

    @Override
    public Annotation getFilterQualifier() {
        return HttpClientModule.filterQualifier(this.annotation);
    }

    void withConfigDefaults(ConfigDefaults<HttpClientConfig> configDefaults) {
        this.configDefaults = configDefaults;
    }

    void withPrivateIoThreadPool() {
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(JettyIoPoolConfig.class, this.annotation, this.name);
        this.binder.bind(JettyIoPoolManager.class).annotatedWith(this.annotation).toInstance((Object)new JettyIoPoolManager(this.name, this.annotation));
    }

    @Override
    public void configure() {
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(HttpClientConfig.class, this.annotation, this.name);
        if (this.configDefaults != null) {
            ConfigBinder.configBinder((Binder)this.binder).bindConfigDefaults(HttpClientConfig.class, this.configDefaults);
        }
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(JettyIoPoolConfig.class);
        this.binder.bind(JettyIoPoolManager.class).to(SharedJettyIoPoolManager.class).in(Scopes.SINGLETON);
        this.binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.name, this.annotation)).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)HttpClientModule.filterQualifier(this.annotation));
        ExportBinder.newExporter((Binder)this.binder).export(HttpClient.class).annotatedWith(this.annotation).withGeneratedName();
    }

    @Override
    public void addAlias(Class<? extends Annotation> alias) {
        this.binder.bind(HttpClient.class).annotatedWith(alias).to(Key.get(HttpClient.class, (Class)this.annotation));
    }

    private static <T> Key<T> keyFromNullable(Class<T> type, Class<? extends Annotation> annotation) {
        return annotation != null ? Key.get(type, annotation) : Key.get(type);
    }

    private static Key<Set<HttpRequestFilter>> filterKey(Class<? extends Annotation> annotation) {
        return Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, (Annotation)HttpClientModule.filterQualifier(annotation));
    }

    private static CompositeQualifier filterQualifier(Class<? extends Annotation> annotation) {
        return CompositeQualifierImpl.compositeQualifier(annotation, HttpClient.class);
    }

    @VisibleForTesting
    public static class JettyIoPoolManager {
        private final List<JettyHttpClient> clients = new ArrayList<JettyHttpClient>();
        private final String name;
        private final Class<? extends Annotation> annotation;
        private final AtomicBoolean destroyed = new AtomicBoolean();
        private JettyIoPool pool;
        private Injector injector;

        private JettyIoPoolManager(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        public void addClient(JettyHttpClient client) {
            this.clients.add(client);
        }

        public boolean isDestroyed() {
            return this.destroyed.get();
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        @PreDestroy
        public void destroy() {
            for (JettyHttpClient client : this.clients) {
                client.close();
            }
            if (this.pool != null) {
                this.pool.close();
                this.pool = null;
            }
            this.destroyed.set(true);
        }

        public JettyIoPool get() {
            if (this.pool == null) {
                JettyIoPoolConfig config = (JettyIoPoolConfig)this.injector.getInstance(HttpClientModule.keyFromNullable(JettyIoPoolConfig.class, this.annotation));
                this.pool = new JettyIoPool(this.name, config);
            }
            return this.pool;
        }
    }

    private static class SharedJettyIoPoolManager
    extends JettyIoPoolManager {
        private SharedJettyIoPoolManager() {
            super("shared", null);
        }
    }

    private static class HttpClientProvider
    implements Provider<HttpClient> {
        private final String name;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private HttpClientProvider(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public HttpClient get() {
            JettyIoPoolManager ioPoolProvider;
            HttpClientConfig config = (HttpClientConfig)this.injector.getInstance(Key.get(HttpClientConfig.class, this.annotation));
            Set filters = (Set)this.injector.getInstance(HttpClientModule.filterKey(this.annotation));
            if (this.injector.getExistingBinding(Key.get(JettyIoPoolManager.class, this.annotation)) != null) {
                log.debug("HttpClient %s uses private IO thread pool", this.name);
                ioPoolProvider = (JettyIoPoolManager)this.injector.getInstance(Key.get(JettyIoPoolManager.class, this.annotation));
            } else {
                log.debug("HttpClient %s uses shared IO thread pool", this.name);
                ioPoolProvider = (JettyIoPoolManager)this.injector.getInstance(JettyIoPoolManager.class);
            }
            JettyHttpClient client = new JettyHttpClient(config, ioPoolProvider.get(), ImmutableList.copyOf(filters));
            ioPoolProvider.addClient(client);
            return client;
        }
    }
}

