/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.stats;

import com.facebook.presto.jdbc.internal.airlift.stats.ExponentiallyDecayingSample;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;

@Deprecated
public class TimedStat {
    private final AtomicLong sum = new AtomicLong(0L);
    private final AtomicLong count = new AtomicLong(0L);
    private final ExponentiallyDecayingSample sample = new ExponentiallyDecayingSample(1028, 0.015);

    @Managed
    public long getCount() {
        return this.count.get();
    }

    @Managed
    public double getSum() {
        return this.sum.get();
    }

    @Managed
    public double getMin() {
        List<Long> values = this.sample.values();
        if (!values.isEmpty()) {
            return Collections.min(values).longValue();
        }
        return Double.NaN;
    }

    @Managed
    public double getMax() {
        List<Long> values = this.sample.values();
        if (!values.isEmpty()) {
            return Collections.max(values).longValue();
        }
        return Double.NaN;
    }

    @Managed
    public double getMean() {
        List<Long> values = this.sample.values();
        if (!values.isEmpty()) {
            long sum = 0L;
            for (long value : values) {
                sum += value;
            }
            return (double)sum * 1.0 / (double)values.size();
        }
        return Double.NaN;
    }

    @Managed
    public double getPercentile(double percentile) {
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("percentile must be between 0 and 1");
        }
        return this.sample.percentiles(percentile)[0];
    }

    @Managed(description="50th Percentile Measurement")
    public double getTP50() {
        return this.sample.percentiles(0.5)[0];
    }

    @Managed(description="90th Percentile Measurement")
    public double getTP90() {
        return this.sample.percentiles(0.9)[0];
    }

    @Managed(description="99th Percentile Measurement")
    public double getTP99() {
        return this.sample.percentiles(0.99)[0];
    }

    @Managed(description="99.9th Percentile Measurement")
    public double getTP999() {
        return this.sample.percentiles(0.999)[0];
    }

    public void addValue(double value, TimeUnit timeUnit) {
        this.addValue(new Duration(value, timeUnit));
    }

    public void addValue(Duration duration) {
        this.sample.update(duration.toMillis());
        this.sum.addAndGet(duration.toMillis());
        this.count.incrementAndGet();
    }

    public <T> T time(Callable<T> callable) throws Exception {
        long start = System.nanoTime();
        T result = callable.call();
        this.addValue(Duration.nanosSince(start));
        return result;
    }
}

