/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import java.util.Objects;

public class FixedWidthBlock
extends AbstractFixedWidthBlock {
    private final int positionCount;
    private final Slice slice;
    private final Slice valueIsNull;

    public FixedWidthBlock(int fixedSize, int positionCount, Slice slice, Slice valueIsNull) {
        super(fixedSize);
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.slice = Objects.requireNonNull(slice, "slice is null");
        if (valueIsNull.length() < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
    }

    @Override
    protected Slice getRawSlice() {
        return this.slice;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull.getByte(position) != 0;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        long size = this.getRawSlice().length() + this.valueIsNull.length();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public int getRetainedSizeInBytes() {
        long size = this.getRawSlice().getRetainedSize() + this.valueIsNull.getRetainedSize();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        Slice newSlice = this.slice.slice(positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = this.valueIsNull.slice(positionOffset, length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        Slice newSlice = Slices.copyOf(this.slice, positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = Slices.copyOf(this.valueIsNull, positionOffset, length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlock{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", fixedSize=").append(this.fixedSize);
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }
}

