/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.jdbc.internal.spi;

import static java.util.Objects.requireNonNull;

public class BeginDeleteResult
{
    private final ConnectorTableHandle tableHandle;
    private final ColumnHandle rowIdHandle;

    public BeginDeleteResult(ConnectorTableHandle tableHandle, ColumnHandle rowIdHandle)
    {
        this.tableHandle = requireNonNull(tableHandle, "tableHandle is null");
        this.rowIdHandle = requireNonNull(rowIdHandle, "rowIdHandle is null");
    }

    public ConnectorTableHandle getTableHandle()
    {
        return tableHandle;
    }

    public ColumnHandle getRowIdHandle()
    {
        return rowIdHandle;
    }
}
