/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ColumnMetadata;
import com.facebook.presto.jdbc.internal.spi.ConnectorInsertTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorOutputTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayout;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutResult;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableMetadata;
import com.facebook.presto.jdbc.internal.spi.Constraint;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import com.facebook.presto.jdbc.internal.spi.SchemaTablePrefix;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ConnectorMetadata {
    public List<String> listSchemaNames(ConnectorSession var1);

    public ConnectorTableHandle getTableHandle(ConnectorSession var1, SchemaTableName var2);

    default public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    default public ConnectorTableLayout getTableLayout(ConnectorTableLayoutHandle handle) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle var1);

    public List<SchemaTableName> listTables(ConnectorSession var1, String var2);

    public ColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle var1);

    public boolean canCreateSampledTables(ConnectorSession var1);

    public Map<String, ColumnHandle> getColumnHandles(ConnectorTableHandle var1);

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle var1, ColumnHandle var2);

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession var1, SchemaTablePrefix var2);

    public void createTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void dropTable(ConnectorTableHandle var1);

    public void renameTable(ConnectorTableHandle var1, SchemaTableName var2);

    default public void renameColumn(ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming columns");
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void commitCreateTable(ConnectorOutputTableHandle var1, Collection<Slice> var2);

    default public void rollbackCreateTable(ConnectorOutputTableHandle tableHandle) {
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession var1, ConnectorTableHandle var2);

    public void commitInsert(ConnectorInsertTableHandle var1, Collection<Slice> var2);

    default public void rollbackInsert(ConnectorInsertTableHandle insertHandle) {
    }

    default public ColumnHandle getUpdateRowIdColumnHandle(ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support updates or deletes");
    }

    default public ConnectorTableHandle beginDelete(ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public void commitDelete(ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public void rollbackDelete(ConnectorTableHandle tableHandle) {
    }

    public void createView(ConnectorSession var1, SchemaTableName var2, String var3, boolean var4);

    public void dropView(ConnectorSession var1, SchemaTableName var2);

    public List<SchemaTableName> listViews(ConnectorSession var1, String var2);

    public Map<SchemaTableName, String> getViews(ConnectorSession var1, SchemaTablePrefix var2);
}

