package com.facebook.presto.jdbc.internal.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.OptionalInt;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;

final class OptionalIntSerializer extends JsonSerializer<OptionalInt>
{
    static final OptionalIntSerializer INSTANCE = new OptionalIntSerializer();

    @Override
    public void serialize(OptionalInt value, JsonGenerator jgen, SerializerProvider provider)
    throws IOException
    {
        if (value.isPresent()) {
            jgen.writeNumber(value.getAsInt());
        } else {
            jgen.writeNull();
        }
    }
}
