/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.VariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.VariableWidthBlockEncoding;

public abstract class AbstractVariableWidthBlock
implements Block {
    protected abstract Slice getRawSlice(int var1);

    protected abstract int getPositionOffset(int var1);

    protected abstract boolean isEntryNull(int var1);

    @Override
    public BlockEncoding getEncoding() {
        return new VariableWidthBlockEncoding();
    }

    @Override
    public byte getByte(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getByte(this.getPositionOffset(position) + offset);
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getShort(this.getPositionOffset(position) + offset);
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getInt(this.getPositionOffset(position) + offset);
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getLong(this.getPositionOffset(position) + offset);
    }

    @Override
    public float getFloat(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getFloat(this.getPositionOffset(position) + offset);
    }

    @Override
    public double getDouble(int position, int offset) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).getDouble(this.getPositionOffset(position) + offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).slice(this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkReadablePosition(position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getLength(position) < length) {
            return false;
        }
        return otherBlock.bytesEqual(otherPosition, otherOffset, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).equals(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, length);
    }

    @Override
    public int hash(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).hashCode(this.getPositionOffset(position) + offset, length);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getLength(position) < length) {
            throw new IllegalArgumentException("Length longer than value length");
        }
        return -otherBlock.bytesCompare(otherPosition, otherOffset, otherLength, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.getRawSlice(position).compareTo(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeBytes(this.getRawSlice(position), this.getPositionOffset(position) + offset, length);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.writeBytesTo(position, 0, this.getLength(position), blockBuilder);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if (this.isNull(position)) {
            return new VariableWidthBlock(1, Slices.wrappedBuffer(new byte[0]), Slices.wrappedIntArray(0, 0), Slices.wrappedBooleanArray(true));
        }
        int offset = this.getPositionOffset(position);
        int entrySize = this.getLength(position);
        Slice copy = Slices.copyOf(this.getRawSlice(position), offset, entrySize);
        return new VariableWidthBlock(1, copy, Slices.wrappedIntArray(0, copy.length()), Slices.wrappedBooleanArray(false));
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.isEntryNull(position);
    }

    @Override
    public void assureLoaded() {
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

